<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Timeslots;
use App\Models\TimeslotsTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class TimeslotController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Timeslots::orderBy('id','DESC')->get();
        return view('timeslots.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        Timeslots::create($input);
    
        return redirect()->route('timeslots.index')
                        ->with('success','Timeslot created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Timeslots::find($id);
    
        return view('timeslots.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $timeslot = Timeslots::find($id);
        $timeslot->update($input);
        return redirect()->route('timeslots.index')
                        ->with('success','Timeslot updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Timeslots::find($id)->delete();
        return redirect()->route('timeslots.index')
                        ->with('success','Timeslot deleted successfully');
    }

    public function translation($id)
    {
        $data = Timeslots::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = TimeslotsTranslation::where('timeslots_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'timeslots_id' => $id,
                    'lang_code' => $row->language_code,
                    'name' => $data->name,
                    'created_at' => date("Y-m-d H:i:s")
                );
                TimeslotsTranslation::insert($postData);
                $row->details = TimeslotsTranslation::where('timeslots_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('timeslots.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'name' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'name' => $input['name'][$i]
                );
                Timeslots::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'name' => $input['name'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            TimeslotsTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        Session::flash('success', 'Translation updated successfully!');
        return redirect()->route('timeslots.index')
                        ->with('success','Translation updated successfully.');
    }

    public function changeStatus($id){
        $data = Timeslots::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('timeslots.index')
                        ->with('success','Status change successfully');
    }
}
