<!-- Basic table -->
<section id="responsive-datatable">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">{{__('lang.admin_payment_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="card-datatable">
                    <table class="dt-responsive table">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_table_sno')}}</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_price')}}</th>
                                <th>{{__('lang.admin_description')}}</th>
                                <th>{{__('lang.admin_method')}}</th>
                                <th>{{__('lang.admin_payment_status')}}</th>
                                <th>{{__('lang.admin_date')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>{{$res->id}}</td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td>{{\Helpers::currency($res->price)}}</td>
                                <td>{{$res->description}}</td>                                
                                <td>{{$res->method}}</td>
                                <td>{{$res->status}}</td>
                                <td>{{ isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--' }}</td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="7" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--/ Basic table -->