@extends('layouts.site-app')
@section('sitecontent')

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.checkout_title')}}</div>
</section>

<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                @include('partials.site.alert')
                <div class="chooselocation selectlocation">
                    <span><img src="{{asset('site-assets/images/watch-icon.png')}}" /></span>
                    {{__('lang.checout_time_of_delivery')}}
                </div>
                {!! Form::model(null, ['method' => 'POST', 'url' => ['do-place-order']]) !!}
                    @csrf
                    <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}"> 
                    <input type="hidden" name="timeslot_id" id="timeslot_id" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}"> 
                    <div class="addressformbg checkgrp">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="addressform">
                                    <div class="row justify-content-end">
                                        <div class="form-group col-md-12">
                                            <div class="radio">
                                                <div class="row">
                                                    @foreach($response['timeslots'] as $timeslots)
                                                        <input label="{{$timeslots->name}}" type="radio" id="{{$timeslots->name}}" onclick="selectTimeSlot({{$timeslots->id}})" value="{{date('h:i A',strtotime($timeslots->from_time))}}  - {{date('h:i A',strtotime($timeslots->to_time))}}" name="timeslots" checked/>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="chooselocation mt-4 mb-13 selectlocation">
                        <span><img src="{{asset('site-assets/images/payment-icon.png')}}" /></span>
                        {{__('lang.Payment_method')}}
                    </div>

                    <div class="select-address select-address-placeorder paymentmethod">
                        @if(setting('enable_cod')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio1" name="payment_method" value="cash" onclick="onLinePayment('no')" />
                            <label class="custom-control-label" for="customRadio1"> {{__('lang.pay_using_cash_on_delivery')}}</label>
                        </div>
                        @endif

                        @if(setting('enable_wallet')=='1' && $response['total_wallet']>=$total['final_amount'])
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio2" name="payment_method" value="wallet" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio2"> {{__('lang.pay_using_dome_wallet')}}</label>
                            <a href="{{ url('/wallet') }}" style="font-size: 17px;font-weight: bold;top: 17px;color: #124d71;" target="_blank">{{__('lang.my_balance')}} | {{\Helpers::currency($response['total_wallet'])}}</a>
                        </div>
                        @endif
                        @if(setting('enable_oppwa')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio3" name="payment_method" value="Oppwa" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio3"> {{__('lang.pay_using_credit_card')}}</label>
                        </div>
                        @endif
                        @if(setting('enable_razorpay')=='1')
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio4" name="payment_method" value="razorpay" onclick="onLinePayment('yes')" checked/>
                            <label class="custom-control-label" for="customRadio4"> {{__('lang.pay_using_razorpay')}}</label>
                        </div>
                        @endif
                    </div>
                    <div class="cart-total-box">
                        <p><label>{{__('lang.order_sub_total')}}</label> {{\Helpers::currency($total['subtotal'])}}</p>
                        <p><label>{{__('lang.order_vat')}} {{setting('default_tax')}}%</label> {{\Helpers::currency($total['tax'])}}</p>
                        <p><label>{{__('lang.order_delivery')}}</label> {{($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')}}</p>
                        <p class="coupondis"><label>{{__('lang.order_coupon_discount')}}</label> @if($total['is_coupon_applied']) -{{\Helpers::currency($total['promotional_disount'])}} @else 0.00 @endif </p>
                        <p class="totalrow"><label>{{__('lang.order_total')}}</label>  {{\Helpers::currency($total['final_amount'])}}</p>
                        <p id="offline_payment_div" class="hide">
                            <button class="submit-btn mt-3 full-width-btn" type="submit">{{__('lang.place_order_button')}} &nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                        </p>
                    </div>
                {!! Form::close() !!}
                <div id="online_payment_div" class="cart-total-box" style="clear: both;">
                    <form action="{{url('do-place-order')}}" method="post">
                        @csrf
                        <script
                            src="https://checkout.razorpay.com/v1/checkout.js"
                            data-key="{{setting('razorpay_key')}}"
                            data-amount="{{$total['final_amount']*100}}"
                            data-currency="INR"                
                            data-theme.color="#14a1a7",
                            data-button_text = "{{__('lang.place_order_button')}}"
                            data-button_theme = "submit-btn mt-3"
                        ></script>
                        <input type="hidden" name="delivery_address_id" value="{{$delivery_address_id}}"> 
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="{{$response['timeslots'][count($response['timeslots'])-1]->id}}"> 
                        <input type="hidden" name="payment_method" id="payment_method" value="razorpay"> 
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>

<script type="text/javascript">
    function onLinePayment(val) {
        if(val=='yes'){
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").removeClass("hide");
        }
        else{
            $("#online_payment_div").addClass("hide");
            $("#offline_payment_div").removeClass("hide");
        }
    }
</script>
<!-- END: Content-->
@endsection

<style type="text/css">
    .razorpay-payment-button{
        background: #af7ab3;
        color: #fff;
        padding: 0px;
        display: inline-block;
        font-size: 14px;
        font-family: Helvetica-Bold, Helvetica, sans-serif;
        border: none;
        border-radius: 35px;
        height: 60px;
        line-height: 60px;
        padding: 0px 25px;
        width: 100%;
    }
    .razorpay-payment-button:hover {
        background: #06283d;
    }
</style>