@extends('layouts.site-app')
@section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.saved_addresses_title')}}</div>
</section>
<section class="order-details-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                @include('partials.site.user-links')
            </div>
            <div class="col-lg-9 col-md-8">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="alert alert-success" role="alert">
                              {{ Session::get('message') }}
                            </div>
                        </div>
                    </div>
                @endif
                @if(Session::has('error'))
                <div class="row">
                    <div class="col-lg-12">
                        <div class="alert alert-danger" role="alert">
                          {{ Session::get('error') }}
                        </div>
                    </div>
                </div>
                @endif
                <div class="add-address white-bg">
                    <span onclick="showAddressForm()" style="cursor: pointer;">{{__('lang.add_address')}}</span>
                    <a href="javascript:;" onclick="showAddressForm()"><img src="{{asset('site-assets/images/plusico.png')}}" style="width: 30%;" /></a> 
                </div>
                {!! Form::model(null, ['method' => 'POST', 'url' => ['add-address']]) !!}
                    @csrf
                    <input type="hidden" name="location_name" id="location_name" value="">
                    <input type="hidden" name="latitude" id="latitude" value="">
                    <input type="hidden" name="longitude" id="longitude" value="">
                    <input type="hidden" name="city" id="city" value="">
                    <input type="hidden" name="state" id="state" value="">
                    <input type="hidden" name="zipcode" id="zipcode" value="">
                    <input type="hidden" name="country" id="country" value="">
                    <div class="addressformbg" id="addAddressForm" style="display: none">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="map">
                                    <div id="myMap" style="height: 600px;width: 100%;position: relative;overflow: hidden;border: 1px solid #a5a5a5;border-radius: 5px;margin-bottom: 5px"></div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="addressform">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_detact_location')}}</label>
                                            <input type="text" class="form-control" name="google_address" id="google_address"  placeholder="{{__('lang.address_detact_location')}}" />
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_type')}}</label>
                                            <div class="radio">
                                                <input label="" type="radio" id="Home" name="type" value="{{__('lang.address_home')}}" checked />
                                                <input label="" type="radio" id="Office" name="type" value="{{__('lang.address_office')}}" />
                                                <input label="" type="radio" id="Mosque" name="type" value="{{__('lang.address_mosque')}}" />
                                                <input label="" type="radio" id="other" name="type" value="{{__('lang.address_other')}}" />
                                            </div>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.address_title')}}</label>
                                            <input type="text" class="form-control" name="address" placeholder="{{__('lang.address_title')}}" />
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label>{{__('lang.placeholder_note')}}</label>
                                            <textarea class="form-control" name="note" id="note" placeholder="{{__('lang.placeholder_note')}}" style="height: 70px;"  ></textarea>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <button class="save-btn text-uppercase float-left" type="submit">{{__('lang.save_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                            <button class="save-btn text-uppercase float-right" style="background: #af7ab3;">{{__('lang.cancel_button')}}&nbsp;&nbsp;<img src="{{asset('site-assets/images/arrowright.png')}}" class="mt-n-1" /></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                {!! Form::close() !!}
                <div class="select-address save-addresses white-bg">
                    @if(count($data)>0)
                        @foreach($data as $row)
                            <div class="custom-control white-bg">
                                <label class="custom-control-label"> <span>{{$row->type}}</span> @if($row->address!='') {{$row->address}}, @endif  @if($row->city!='') {{$row->city}}, @endif  @if($row->state!='') {{$row->state}}, @endif {{$row->zipcode}}</label>
                                <a onclick="return confirm('{{__('lang.address_delete_confirm')}}');" href="{{url('/delete-address')}}/{{$row->id}}"><img src="{{asset('site-assets/images/delete-icon.png')}}" style="width: 25px;"/></a>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<script type="text/javascript">
    setTimeout(function(){
        getLocation();
    },1500);
</script>
@endsection