@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_app_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                @csrf
                                
                                <div class="row">
                                    @foreach ($data as $row)
                                    @if($row->key=='timezone')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="timezone">{{__('lang.admin_timezone')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_timezone')}}" name="timezone" id="timezone" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='date_format')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_date_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_date_format')}}" name="date_format" id="date_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='date_time_format')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_date_time_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_date_time_format')}}" name="date_time_format" id="date_time_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='time_format')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="date_format">{{__('lang.admin_time_format')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_time_format')}}" name="time_format" id="time_format" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='default_tax')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="default_tax">{{__('lang.admin_default_tax_in')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_default_tax_in')}}" name="default_tax" id="default_tax" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='shipping_charge')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="shipping_charge">{{__('lang.admin_shipping_charge_in')}} {{setting('default_currency_code')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_shipping_charge_in')}}" name="shipping_charge" id="shipping_charge" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='minimum_order_value')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="minimum_order_value">{{__('lang.admin_min_order_value_in')}} {{setting('default_currency_code')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_min_order_value_in')}}" name="minimum_order_value" id="minimum_order_value" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    <!-- @if($row->key=='default_currency')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="default_currency">{{__('lang.admin_default_currency')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_default_currency')}}" name="default_currency" id="default_currency" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif
                                    @if($row->key=='default_currency_code')
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="default_currency_code">{{__('lang.admin_default_currency_code')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_default_currency_code')}}" name="default_currency_code" id="default_currency_code" value="{{$row->value}}" />
                                        </div>
                                    </div>
                                    @endif -->
                                    @endforeach
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                    </div>
                                </div>
                                {{-- {!! Form::close() !!} --}}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection