<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Coupon;
use App\Models\CouponTranslation;

class CouponAPIController extends Controller
{
    protected $num_per_page = '10';
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
    }

    public function couponLists(Request $request)
    {
        try{
            
            $allcodes = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('status',1)->get();
            foreach ($allcodes as $row) {
                $translated_data = CouponTranslation::where('lang_code',$this->language)->where('coupon_id',$row['id'])->first();
                if($translated_data){
                    if($translated_data->coupon_name!=''){
                        $row['coupon_name'] = $translated_data->coupon_name;
                    }
                    if($translated_data->description!=''){
                        $row['description'] = $translated_data->description;
                    }
                }
            }
            return $this->sendResponse($allcodes, 'Coupon retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function doVerifyCode(Request $request)
    {
        try{
            
            $allcodes = Coupon::where('coupon_name',$request->input('code'))->where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('status',1)->orderBy('id','DESC')->first();
            if($allcodes){
                return $this->sendResponse($allcodes, 'Coupon retrieved successfully');    
            }else{
                return $this->sendError('Coupon not found', 401);
            }
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }
}
