<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\DeliveryAddresses;
use App\Models\AppSetting;
use App\Models\UserAuthLogin;
use App\Models\Languages;
use App\Models\Timeslots;
use App\Models\TimeslotsTranslation;
use App\Models\CmsPages;
use App\Models\CmsPagesTranslation;
use App\Models\Partners;
use App\Models\PartnersTranslation;
use App\Models\NonWorkingDays;
use App\Models\DeliveryAreas;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;

class UserAPIController extends Controller
{
    
    private $language;
    public function __construct(Request $request)
    {
        // parent::__construct();
        $this->request = $request; 
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
    }
    
    function doLogin(Request $request)
    {
        $this->validate($request, [
            'phone' => 'required'
        ]);
        $user = User::where('phone', $request->input('phone'))->first();
        $otp = 1234;//rand(1000, 9999);
        if ($user) {
            $postUpdate = array(
                'is_verified' => 0,
                'otp' => $otp
            );
            User::where('id', $user->id)->update($postUpdate);
            $response = array(
                'id' => $user->id,
                'phone' => $user->phone,
                'otp' => $otp,
                'is_verified' => 0
            );
            //\Helpers::sendSms('Your One time Password is ' .$otp,$request->input('phone'));
            return $this->sendResponse($response, 'OTP send successfully.');
        }else{
             $postUpdate = array(
                'phone' => $request->input('phone'),
                'is_verified' => 0,
                'otp' => $otp,
                'password' => Hash::make("123456"),
                'created_at' => date("y-m-d H:i:s")
            );
            $id = User::insertGetId($postUpdate);
            $response = array(
                'id' => $id,
                'phone' => $request->input('phone'),
                'otp' => $otp,
                'is_verified' => 0
            );
            //\Helpers::sendSms('Your One time Password is ' .$otp,$request->input('phone'));
            return $this->sendResponse($response, 'OTP send successfully.');
        }
    }


    function doVerifyOtp(Request $request)
    {
        $this->validate($request, [
            'device_token'=> 'required',
            'device_type'=> 'required',
            'phone' => 'required',
            'otp' => 'required'
        ]);
        $user = User::where('phone', $request->input('phone'))->where('otp', $request->input('otp'))->first();
        if ($user) {
            $postUpdate = array(
                'is_verified' => 1
            );
            User::where('id', $user->id)->update($postUpdate);

            $postUpdate = array(
                'user_id' => $user->id,
                'api_token' => \Helpers::generateApiToken(),
                'device_token' => $request->input('device_token'),
                'device_type' => $request->input('device_type'),
                'created_at' => date("y-m-d H:i:s")
            );
            UserAuthLogin::insert($postUpdate);
            return $this->sendResponse($postUpdate, 'User retrieved successfully.');
        }else{
            return $this->sendError('User not found', 401);
        }
    }

    function doResndOtp(Request $request)
    {
        $this->validate($request, [
            'phone' => 'required'
        ]);
        $user = User::where('phone', $request->input('phone'))->first();
        if ($user) {
            $response = array(
                'id' => $user->id,
                'phone' => $user->phone,
                'is_verified' => 0
            );
            //\Helpers::sendSms('Your One time Password is ' .$user->otp,$request->input('phone'));
            return $this->sendResponse($response, 'OTP send successfully.');
        }else{
            return $this->sendError('User not found', 401);
        }
    }

   function doDriverLogin(Request $request)
    {

        $rules = [
            'username' => 'required',
            'password' => 'required',
        ];

        $request->validate($rules);

        if (auth()->attempt(['phone' => $request->input('username'), 'password' => $request->input('password')])) {
            $user = auth()->user();
            if($user->status==1){
                $postUpdate = array(
                    'user_id' => $user->id,
                    'api_token' => \Helpers::generateApiToken(),
                    'created_at' => date("y-m-d H:i:s")
                );
                UserAuthLogin::insert($postUpdate);
                $response = ['user' => $user->id, 'token' => \Helpers::generateApiToken()];
            return $this->sendResponse($postUpdate, 'Driver retrieved successfully');
                
            }else{
                return $this->sendError('Driver Is not active'); 
            }
        }else{
            return $this->sendError('Driver valid details');
        }
    }

    

    function getProfile(Request $request){
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    return $this->sendResponse($request->userAuthData->user, 'Profile retrieved successfully');
                }
            }
            return $this->sendError('User not found', 401);
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }

    function getDriverProfile(Request $request){
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    return $this->sendResponse($request->userAuthData->user, 'Profile retrieved successfully');
                }
            }
            return $this->sendError('User not found', 401);
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }

    /**
     *  update profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doUpdateProfile(Request $request)
    {
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    $post = $request->all();
                    $user = $request->userAuthData->user;
                    

                    if($request->input('phone')!=''){
                        $userPhone = User::where('phone', $request->input('phone'))->where('id','!=',$user->id)->first();
                        if ($userPhone) {
                            return $this->sendError('Mobile number is already exists', 401);
                        }
                    }

                    if($request->input('email')!=''){
                        $userEmail = User::where('email', $request->input('email'))->where('id','!=',$user->id)->first();
                        if ($userEmail) {
                            return $this->sendError('Email is already exists', 401);
                        }
                    } 

                    $postData = array(
                        'updated_at' => date("Y-m-d H:i:s")
                    );
                    if(isset($post['name'])){
                        $postData['name'] = $post['name'];
                    }

                    if(isset($post['lang_code'])){
                        $postData['lang_code'] = $post['lang_code'];
                    }

                    if(isset($post['phone'])){
                        $postData['phone'] = $post['phone'];
                    }

                    if(isset($post['email'])){
                        $postData['email'] = $post['email'];
                    }
                    User::where('id', $user->id)->update($postData);
                    $user = User::where('id',$user->id)->first();
                    return $this->sendResponse($user, 'Succefully updated');
                }
            }
            return $this->sendError('User not found', 401);
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }

    public function doUpdateDriverProfile(Request $request)
    {
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    $post = $request->all();
                    $user = $request->userAuthData->user;

                    $user2 = User::where('phone', $request->input('phone'))->where('id','!=',$user->id)->first();
                    if ($user2) {
                        return $this->sendError('Mobile number is already exists', 401);
                    }

                    $user3 = User::where('email', $request->input('email'))->where('id','!=',$user->id)->first();
                    if ($user3) {
                        return $this->sendError('Email is already exists', 401);
                    }

                    $postData = array(
                        'updated_at' => date("Y-m-d H:i:s")
                    );
                    if(isset($post['name'])){
                        $postData['name'] = $post['name'];
                    }

                    if(isset($post['lang_code'])){
                        $postData['lang_code'] = $post['lang_code'];
                    }

                    if(isset($post['phone'])){
                        $postData['phone'] = $post['phone'];
                    }

                    if(isset($post['email'])){
                        $postData['email'] = $post['email'];
                    }
                    User::where('id', $user->id)->update($postData);
                    $user = User::where('id',$user->id)->first();
                    return $this->sendResponse($user, 'Succefully updated');
                }
            }
            return $this->sendError('User not found', 401);
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }

    /**
     *  update profile
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doUpdateNotification(Request $request)
    {
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    $post = $request->all();
                    $user = $request->userAuthData->user;
                    $postData = array(
                        'updated_at' => date("Y-m-d H:i:s")
                    );
                    
                    if(isset($post['enable_notificaton'])){
                        $postData['enable_notificaton'] = $post['enable_notificaton'];
                    }else{
                        $postData['enable_notificaton'] = 0;
                    }
                    User::where('id', $user->id)->update($postData);
                    $user = User::where('id',$user->id)->first();
                    return $this->sendResponse($user, 'Succefully updated');
                }
            }
            return $this->sendError('User not found', 401);
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }

    public function listUserAddress(Request $request)
    {
        try{
            $user_id = 0;            
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            $results = DeliveryAddresses::where('user_id',$user_id)->get();
            return $this->sendResponse($results, 'User address retrieved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function addUpdateUserAddress(Request $request)
    {
        try{

            $user_id = 0;            
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            $post = $request->all();
            $post['user_id'] = $user_id;

            if($post['id']){
                DeliveryAddresses::where('id',$post['id'])->update($post);
            }else{
                DeliveryAddresses::create($post);                
            }
            $results = DeliveryAddresses::where('user_id',$user_id)->get();
            return $this->sendResponse($results, 'User address saved successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function deleteUserAddress($id,Request $request)
    {
        try{
            
            DeliveryAddresses::where('id',$id)->delete();
            return $this->sendResponse([], 'User address deleted successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function setDefaultUserAddress($id,Request $request)
    {
        try{
            $user_id = 0;            
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            $post = $request->all();
            $results = DeliveryAddresses::where('user_id',$user_id)->update(array('is_default'=>$post['is_default']));
            DeliveryAddresses::where('id',$id)->update(array('is_default'=>1));
            
            return $this->sendResponse([], 'User address updated successfully');
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    function settings(Request $request)
    {
        $response = array();
        $response['delivery_areas'] = DeliveryAreas::where('status',1)->get();
        $response['holidays'] = NonWorkingDays::where('status',1)->get();
        $response['setting'] = AppSetting::all();
        $response['languages'] = Languages::all();
        $response['timeslots'] = Timeslots::all();
        $response['terms'] = CmsPages::where('page_name','terms')->first();
        if($response['terms']){
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$response['terms']->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $response['terms']->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $response['terms']->description = $translated_data->description;
                }
            }
        }

        $response['about_us'] = CmsPages::where('page_name','about')->get();
        foreach ($response['about_us'] as $row) {
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$row->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $row->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $row->description = $translated_data->description;
                }
            }
        }

        
        foreach ($response['timeslots'] as $row) {
            $translated_data = TimeslotsTranslation::where('lang_code',$this->language)->where('timeslots_id',$row->id)->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row->name = $translated_data->name;
                }
            }
        }

        $response['partners'] = Partners::where('type','partner')->get();
        foreach ($response['partners'] as $row) {
            $translated_data = PartnersTranslation::where('lang_code',$this->language)->where('partner_id',$row->id)->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row->name = $translated_data->name;
                }
            }
        }

        $response['awards'] = Partners::where('type','awards')->get();
        foreach ($response['awards'] as $row) {
            $translated_data = PartnersTranslation::where('lang_code',$this->language)->where('partner_id',$row->id)->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row->name = $translated_data->name;
                }
            }
        }

        return $this->sendResponse($response, 'Settings retrieved successfully');
    }

    public function doLogout(Request $request)
    {
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    $post = $request->all();
                    $user = $request->userAuthData->user;
                    $postUpdate = array(
                        'user_id' => $user->id,
                        'api_token' => '',
                        'device_token' => '',
                        'updated_at' => date("y-m-d H:i:s")
                    );
                    UserAuthLogin::where('id',$request->userAuthData->id)->update($postUpdate);
                    return $this->sendResponse([], 'Logout Succefully updated');
                }
            }
            return $this->sendError('User not found', 401);
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }

    public function doDriverLogout(Request $request)
    {
        try{
            if($request->userAuthData){
                if($request->userAuthData->user){
                    $post = $request->all();
                    $user = $request->userAuthData->user;
                    $postUpdate = array(
                        'user_id' => $user->id,
                        'api_token' => '',
                        'device_token' => '',
                        'updated_at' => date("y-m-d H:i:s")
                    );
                    UserAuthLogin::where('id',$request->userAuthData->id)->update($postUpdate);
                    return $this->sendResponse([], 'Logout Succefully updated');
                }
            }
            return $this->sendError('Driver not found', 401);
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
}
