<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use App\Models\AppSetting;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class AppSettingController extends Controller
{
    public function setLanguage(Request $request){
        $post = $request->all();
        if (array_key_exists($post['lang'], Config::get('languages'))) {
            if (isset($post['lang'])) {
                $direction = \Helpers::getLangData($post['lang']);
                App::setLocale($post['lang']);
                Session::put('admin_locale', $post['lang']);
                Session::put('admin_direction', $direction);
                setcookie('admin_lang_code',$post['lang'],time()+60*60*24*365);
            }
        }
        return redirect()->back();
    }

    public function index($type = null, $tab = null)
    {
        if (empty($type)) {
            Flash::error(trans('lang.app_setting_global') . 'not found');
            return redirect()->back();
        }
        $appSetting  = AppSetting::get();
        return view('settings.' . $type . '.' . $tab . '')->with('data',$appSetting);
    }

    public function updateSetting(Request $request)
    {
        $post = $request->all();

        $page_name = (isset($post['page_name']))?$post['page_name']:'';
        if($page_name!=''){
            $myAr = array();
            if($page_name=='non-working-days')
            {
                $myAr = array("mon_working","tue_working","wed_working","thu_working","fri_working","sat_working","sun_working");
            }
            else if($page_name=='payment')
            {
                $myAr = array("enable_wallet","enable_oppwa","enable_cod","enable_razorpay","razorpay_key","razorpay_secret");
            }
            foreach ($myAr as $r) {
                $value = (isset($post[$r]))?$post[$r]:0;
                $exist = AppSetting::where('key',$r)->first();
                if($exist){
                    AppSetting::where('id',$exist->id)->update(array('value'=>$value,'updated_at' => date("y-m-d H:i:s")));
                }else{
                    AppSetting::insert(array('value'=>$value,'key'=>$r,'updated_at' => date("y-m-d H:i:s")));
                }    
            }
        }else{ 
            if ($image = $request->file('about_product')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "about_product." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['about_product'] = "$profileImage";
            }else{
                unset($post['about_product']);
            }

            if ($image = $request->file('website_logo')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "website_logo." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['website_logo'] = "$profileImage";
            }else{
                unset($post['website_logo']);
            }

            if ($image = $request->file('mobile_image')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "mobile_image." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['mobile_image'] = "$profileImage";
            }else{
                unset($post['mobile_image']);
            }


            if ($image = $request->file('icon_1')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_1." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_1'] = "$profileImage";
            }else{
                unset($post['icon_1']);
            }

            if ($image = $request->file('icon_2')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_2." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_2'] = "$profileImage";
            }else{
                unset($post['icon_2']);
            }

            if ($image = $request->file('icon_3')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_3." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_3'] = "$profileImage";
            }else{
                unset($post['icon_3']);
            }

            if ($image = $request->file('icon_4')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_4." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_4'] = "$profileImage";
            }else{
                unset($post['icon_4']);
            }

            if ($image = $request->file('website_bg_image')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "website_bg_image." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['website_bg_image'] = "$profileImage";
            }else{
                unset($post['website_bg_image']);
            }
            foreach ($post as $key => $value) {
                if($key!='_method' && $key!='_token'){
                    if($value!='' && $value!=null){
                        $exist = AppSetting::where('key',$key)->first();
                        if($exist){
                            AppSetting::where('id',$exist->id)->update(array('value'=>$value,'updated_at' => date("y-m-d H:i:s")));
                        }else{
                            AppSetting::insert(array('value'=>$value,'key'=>$key,'created_at' => date("y-m-d H:i:s")));
                        }
                    }
                }
            }
        }
        $settingsc = AppSetting::all();
        foreach ($settingsc as $row) {
            Setting::set($row->key, $row->value);
        }
        Setting::save();
        Session::flash('success', 'Record updated successfully!');
        return redirect()->back()->with('success','Info updated successfully');
    }
}
