<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Cart;
use App\Models\UserAuthLogin;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Support\Facades\Response;
use DB;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $data = User::getLists('user')->where('type','user');
        return view('a_customer.index',compact('data'));
    }

    public function create()
    {
        $roles = Role::pluck('name','name')->all();
        return view('a_customer.create',compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);    
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        $user = User::create($input);
        Session::flash('success', 'User created successfully!');
        return redirect()->route('customer.index')
                        ->with('success','User created successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
    
        return view('customer.edit',compact('user'));
    }

    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }
        $user = User::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $user->update($input);
        Session::flash('success', 'Profile updated successfully!');
        if ($user->type == 'admin'){
            return redirect()->route('customer.profile')
                        ->with('success','Profile updated successfully');
        }else{
            return redirect()->route('customer.index')
                        ->with('success','User updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        Session::flash('success', 'Profile deleted successfully!');
        return redirect()->route('customer.index')
                        ->with('success','User deleted successfully');
    }

    /**
     * Display a user profile.
     *
     * @param
     * @return Response
     */
    public function profile()
    {
        $id = 1;
        $user = User::find($id);
        unset($user->password);
        return view('customer.profile', compact(['user']));
    }

    function doVerifyOtp(Request $request)
    {
        $post = $request->all();
        $this->validate($request, [
            'phone_number' => 'required'
        ]);
        $verification_code = $post['otp_1'].$post['otp_2'].$post['otp_3'].$post['otp_4'];
        
        $user = User::where(['phone' => $post['phone_number'], 'otp' => $verification_code])->first();
        if($user){
            Auth::loginUsingId($user->id);
            $user = Auth::user();
            $success = array();
            $success['token'] =  \Helpers::generateApiToken();
            
            $postUpdate = array(
                'is_verified' => 1
            );
            User::where('id', $user->id)->update($postUpdate);
            $cartCount = Cart::where('user_id',$user->id)->count();
            Session::put('total_cart', $cartCount);
            return redirect('/profile')->with('success','Reply send successfully');
        }
        else{
            Session::flash('error', 'Login details are invalid!'); 
            return redirect()->back()->with('error','Login details are invalid!');
        }
    }

    public function changeStatus($id){
        $data = User::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('customer.index')
                        ->with('success','Status change successfully');
    }

    public function userWalletLists(Request $request, $id)
    {
        $user = User::find($id);
        $data = UserWallet::getUserWalletLists($id);
        return view('customer.wallet',compact('data'))->with("user",$user);
    }

    public function doSubmituserWallet(Request $request, $id)
    {
        $post = $request->all();

        request()->validate([
            'amount' => 'required',
            'description' => 'required',
            'type' => 'required',
        ]);
        $input = $request->all();

        $postData = array(
            'user_id' => $id,
            'description' => $input['description'],
            'type' => $input['type'],
            'created_at' => date("Y-m-d H:i:s")
        );
        if($input['type']=='debit'){
            $postData['amount'] = '-'.$input['amount'];
        }else{
            $postData['amount'] = $input['amount'];
        }
        

        UserWallet::insert($postData);

        Session::flash('success', 'Wallet transaction submited successfully!');
        return redirect()->back()->with('success','Wallet transaction submited successfully!');
    }
}
   