<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiAuthenticate
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  ...$guards
     * @return mixed
     */
    public function handle(Request $request, Closure $next, ...$guards)
    {
        $headerData = ($request->header('api-token')? $request->header('api-token'):$request->header('api-token'));
        $tokenData = \Helpers::velidateAuthToken($headerData);
        if (! $tokenData) {
            return \Helpers::sendFailureResponse('Unauthenticated', 401);
        }
        $request->userAuthData = $tokenData;
        return $next($request);
    }
}
