<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DeliveryAreas extends Model
{
    use HasFactory;

    public $fillable = [
        'zip_code',
        'country',
        'location_name',
        'city',
        'region',
        'status'
    ];
    
    public static function getLists()
    {
        try {
          $query = new Self;
          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    
}
