@extends('layouts.site-app') @section('sitecontent')
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        @include('partials.site.header-menu')
    </div>
    <div class="inner-heading">{{__('lang.about_us_title')}}</div>
</section>
<section class="aboutbg">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="about-content">
                    <h1>{{$data->page_title}}</h1>
                    <div class="about-content-inner">
                        <p><?php echo $data->description; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="ourpartners">
        <div class="row text-center">
            <div class="text-center">
                <h1 class="inner-heading">Our Partners</h1>
            </div>
        </div>
        <div class="row justify-content-center">
            <div id="owl-carousel1" class="row owl-carousel owl-theme aboutpages">
                @foreach ($partners as $partner)
                <div class="col-md-2">
                    <div class="item">
                        <div class="partner-logo">
                            @if($partner->image!='')
                            <img
                                src="{{asset('/app-assets/images/partners/'.$partner->image)}}"
                                alt="{{$partner->name}}"
                                title="{{$partner->name}}"
                            />
                            @else
                            <img
                                src="https://thumbs.dreamstime.com/b/partner-logo-design-ai-supported-81263747.jpg"
                                alt="{{$partner->name}}"
                                title="{{$partner->name}}"
                            />
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        <div class="row text-center">
            <div class="text-center">
                <h1 class="inner-heading">Our Awards</h1>
            </div>
        </div>
        <div class="row justify-content-center">
            <div id="owl-carousel2" class="row owl-carousel owl-theme aboutpages" style="">
                @foreach ($awards as $award)
                <div class="col-md-2">
                    <div class="item">
                        <div class="partner-logo">
                            @if($award->image!='')
                            <img
                                src="{{asset('/app-assets/images/partners/'.$award->image)}}"
                                alt="{{$award->name}}"
                                title="{{$award->name}}"
                            />
                            @else
                            <img
                                src="https://thumbs.dreamstime.com/b/partner-logo-design-ai-supported-81263747.jpg"
                                alt="{{$partner->name}}"
                                title="{{$partner->name}}"
                            />
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
</section>
<footer class="footer">
    @include('partials.site.footer')
</footer>
<!-- END: Content-->
@endsection