@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_about_us')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('about_us.index')!!}">{{__('lang.admin_about_us_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_about_us_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($data, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['about_us.update', $data->id],'class'=> 'add-new-record  modal-content pt-0']) !!}
                                <div class="d-flex mb-2">
                                    @if($data->image!='')
                                    <img src="{{asset('app-assets/images/partners')}}/{{$data->image}}" alt="image" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';" />
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="image"
                                        class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                        <h4>{{$data->name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image" />
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_type')}}</label>
                                            <select id="type" class="form-select" name="type">
                                                <option value="awards"
                                                    <?php if($data->type=='awards')'selected' ?>>{{__('lang.admin_about_us_award')}}</option>
                                                <option value="partner"
                                                    <?php if($data->type=='partner')'selected' ?>>{{__('lang.admin_about_us_partner')}}
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_name')}}</label>
                                            <input type="text" id="basic-icon-default-language_code" class="form-control dt-discount_price" placeholder="{{__('lang.admin_name')}}" aria-label="{{__('lang.admin_language_placeholder')}}" name="name" value="{{ isset($data->name)?$data->name:'--' }}" />
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('about_us.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                        {{-- <button type="submit" class="btn btn-primary data-submit me-1">{{__('lang.admin_button_update')}}</button>
                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{__('lang.admin_button_cancel')}}</button> --}}
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->
@endsection