@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_keyword_language')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_keyword_language')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons text-end">
                    <form id="formData" method="get">
                        <div class="row">
                            <div class="form-group col-sm-3">
                                <input type="text" name="search" placeholder="Search by value" class="form-control" @if(isset($_GET['search'])) value="{{$_GET['search']}}" @endif>
                            </div>
                            <div class="form-group col-sm-3">
                                <select class="form-select" name="group" id="group">
                                    <option value="">Platform</option>
                                    <option value="web" @if(isset($_GET['group'])) @if($_GET['group']=='web') selected @endif @endif>Web</option>
                                    <option value="admin" @if(isset($_GET['group'])) @if($_GET['group']=='admin') selected @endif @endif>Admin</option>
                                    <option value="api" @if(isset($_GET['group'])) @if($_GET['group']=='api') selected @endif @endif>{{__('lang.admin_mobile')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <select class="form-select" name="lang_code" id="lang_code" style="width: -webkit-fill-available">
                                    <option value="">{{__('lang.admin_select_language')}}</option>
                                    @foreach($language as $lang)
                                        <option value="{{$lang->language_code}}" @if(isset($_GET['lang_code'])) @if($_GET['lang_code']==$lang->language_code) selected @endif @endif>{{$lang->language_name}} ({{$lang->language_code}})</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        @include('keywords.table')
    </div>
</div>
@endsection