<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_active_subscription_list')}}</h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> {{__('lang.admin_showing')}} {{ $data->firstItem() }}-{{ $data->lastItem() }} {{__('lang.admin_of')}} {{ $data->total() }} <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_order_item_name')}}</th>
                                <th>{{__('lang.admin_order_delivery')}}</th>
                                <th>{{__('lang.admin_order_delivery_date')}}</th>
                                <th>{{__('lang.admin_start_date')}}</th>
                                <th>{{__('lang.admin_end_date')}}</th>
                                <th>{{__('lang.admin_price')}}</th>
                                <th>{{__('lang.admin_order_quantity')}}</th>
                                <th>{{__('lang.admin_amount')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <tr>
                                <td>{{$i}}</td>
                                <td>{{ isset($res->user)?$res->user->phone:'--' }}</td>
                                <td>{{isset($res->product->name)?$res->product->name:'--' }}</td>
                                <td style="text-transform: capitalize;">{{isset($res->order_frequency) ? $res->order_frequency : '--' }}</td>
                                @if($res->order_frequency == 'once')
                                <td>
                                    @if(isset($res->end_date))
                                        {{\Helpers::commonDateFormate($res->end_date)}}
                                    @else
                                        @if($res->product_deliverys)
                                            @if(isset($res->product_deliverys[count($res->product_deliverys)-1]))
                                                {{\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)}}
                                            @else
                                                --
                                            @endif
                                        @else
                                            --
                                        @endif
                                    @endif
                                </td>
                                @else 
                                <td>
                                    <button class="dropdown-item" data-bs-toggle="modal" data-bs-target="#modalsDates_{{$res->id}}">
                                        <i data-feather="eye" class="me-50"></i>
                                        <span>{{__('lang.admin_dashboard_view_all')}}</span>
                                    </button>
                                    <div class="modal fade text-start" id="modalsDates_{{$res->id}}" tabindex="-1" aria-labelledby="myModalLabel160" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered modal-xs">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel160">{{__('lang.admin_order_delivery_date')}}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    @foreach($res->product_deliverys as $deliveries)
                                                    <ul class="list-group">
                                                        <li class="list-group-item">{{\Helpers::commonDateFormate($deliveries->delivery_date)}} <small class="text-right">{{$deliveries->delivery_status->status}}</small></li>
                                                    </ul>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                @endif
                                <td>
                                    @if(isset($res->start_date))
                                        {{\Helpers::commonDateFormate($res->start_date)}}
                                    @else
                                        @if(isset($res->product_deliverys[0]))
                                            {{\Helpers::commonDateFormate($res->product_deliverys[0]->delivery_date)}}
                                        @else
                                            --
                                        @endif
                                    @endif
                                </td>
                                <td>
                                    @if(isset($res->end_date))
                                        {{\Helpers::commonDateFormate($res->end_date)}}
                                    @else
                                        @if($res->product_deliverys)
                                            @if(isset($res->product_deliverys[count($res->product_deliverys)-1]))
                                                {{\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)}}
                                            @else
                                                --
                                            @endif
                                        @else
                                            --
                                        @endif
                                    @endif
                                </td>
                                <td>{{\Helpers::currency($res->per_delivery_amount)}}</td>
                                <td>{{$res->quantity}}</td>
                                <td>{{\Helpers::currency($res->total_delivery_amount)}}</td>
                            </tr>
                            <?php $i++; ?>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="10" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        {{$data->withQueryString()->links('pagination::bootstrap-4')}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>