@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-12 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_order_cancel_request')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a></li>
                                <li class="breadcrumb-item active">{{__('lang.admin_request_list')}}</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-header-right text-md-end col-md-12 col-12 d-md-block mb-2">
                <div class="dt-action-buttons text-end">
                    <form id="formData" method="get">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <select class="form-select" name="status" id="status">
                                    <option value="">{{__('lang.admin_cancel_status')}}</option>
                                    <option value="0">{{__('lang.admin_pending')}}</option>
                                    <option value="1">{{__('lang.admin_approved')}}</option>
                                    <option value="2">{{__('lang.admin_declined')}}</option>
                                </select>
                            </div>
                            <div class="form-group col-sm-4">
                                <select class="form-select" name="user_id" id="search_order_by_user_id" style="width: -webkit-fill-available">
                                    <option value="">{{__('lang.admin_select_user')}}</option>
                                    @foreach($filter['user'] as $user)
                                        <option value="{{$user->id}}" @if(isset($_GET['user_id'])) @if($_GET['user_id']==$user->id) selected @endif @endif>{{$user->phone}} @if($user->name!='' || $user->name!=null)({{$user->name}})@endif</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <input type="submit" name="submit" value="{{__('lang.admin_button_search')}}" id="submit" class="dt-button create-new btn btn-primary">
                                <a href="javascript:;" onclick="resetFilter()" class="btn btn-danger">{{__('lang.admin_button_reset')}}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @include('orders.cancelrequest.table')
        </div>
    </div>
</div>
<!-- END: Content-->
@endsection