@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_social_links')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                    @csrf                                
                                    <div class="row">
                                        @foreach ($data as $row)
                                            @if($row->key=='facebook_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="facebook">{{__('lang.admin_social_link_facebook')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_social_link_facebook_placeholder')}}" name="facebook_url" id="facebook" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                            @if($row->key=='twitter_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="twitter_url">{{__('lang.admin_social_link_twitter')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_social_link_twitter_placeholder')}}" name="twitter_url" id="twitter_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                            @if($row->key=='instagram_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="instagram_url">{{__('lang.admin_social_link_instagram')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_social_link_instagram_placeholder')}}" name="instagram_url" id="instagram_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                            @if($row->key=='pinterest_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="pinterest_url">{{__('lang.admin_social_link_pinterest')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_social_link_pinterest_placeholder')}}" name="pinterest_url" id="pinterest_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                            @if($row->key=='snapchat_url')
                                                <div class="col-md-6">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="snapchat_url">{{__('lang.admin_social_link_snapchat')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_social_link_snapchat')}}" name="snapchat_url" id="snapchat_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                        <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        </div>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection