@extends('layouts.app')
@section('content')
<script src="https://cdn.ckeditor.com/ckeditor5/28.0.0/classic/ckeditor.js"></script>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_cms')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item"><a href="{!! route('site_contents.index') !!}">{{__('lang.admin_cms_pages_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_cms_pages_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($data, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['site_contents.update', $data->id]]) !!}
                                @csrf
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{__('lang.admin_cms_page_title')}}</label>
                                            <input type="text" class="form-control " placeholder="{{__('lang.admin_cms_page_title')}}" value="{{$data->page_title}}" name="page_title" id="page_title" />
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{__('lang.admin_cms_page_description')}}</label>
                                            <textarea class="form-control" name="description" id="editor" name="{{__('lang.admin_cms_page_description')}}" value="{{$data->description}}">{{$data->description}}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('site_contents.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<script type="text/javascript">
    ClassicEditor
    .create( document.querySelector( '#editor' ), {} )
    .catch( error => {
        console.log( error );
    } );
</script>
@endsection

