<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Coupon;
use App\Models\CouponTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;
use DB;

class CouponController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $coupons = DB::table('coupon_book')->get();
        return view('coupons.index',compact('coupons'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input =['book_no'  => $request->input('coupon_book_number'),
                 'start_number' => $request->input('start_number'),
                 'no_coupons'   => $request->input('number_of_coupons'),
                 'status'       => 'inactive',
                 'date'         => date('Y-m-d H:i:s')
             ]  ;
      
        DB::table('coupon_book')->insert($input);
        $start_number = $request->input('start_number');
        $end_number = $start_number + $request->input('number_of_coupons');
        $book_id = DB::table('coupon_book')->where('book_no',$request->input('coupon_book_number'))->first()->id;
        for($i=$start_number;$i< $end_number;$i++)
        {
            $data = ['book_id'=>$book_id,'coupon_number'=>$i,'status'=>'inactive','date'=>date('Y-m-d H:i:s')];
            DB::table('coupon')->insert($data);
        }
        Session::flash('success', 'Coupon created successfully!');
        return redirect()->route('coupons.index')
                        ->with('success','Coupon created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = DB::table('coupon_book')->where('id',$id)->get();
        return view('coupons.edit',compact('coupon'));
    }

    public function assign($id)
    {
        $coupon = DB::table('coupon_book')->where('id',$id)->get();
        $id = $id;
        $number = DB::table('coupon_book')->where('id',$id)->first()->book_no;
        $customer = DB::table('users')->where('type','user')->get();
        return view('coupons.assign',compact('coupon','customer','number','id'));
    }

    public function assigned(Request $request,$id)
    {
        $coupon_id = $id;
        $data = ['assigned'=>$request->input('user')];

        DB::table('coupon_book')->where('id',$coupon_id)->update($data);
        
        return redirect()->route('coupons.index')
                        ->with('success','Coupon assigned successfully');
    }

    public function redeemCoupon(Request $request)
    {
        
        
        return view('coupons.redeem');
    }
     public function doRedeemCoupon(Request $request)
    {
        $coupon_id = $id;
        $data = ['assigned'=>$request->input('user')];

        DB::table('coupon_book')->where('id',$coupon_id)->update($data);
        
        return redirect()->route('coupons.index')
                        ->with('success','Coupon assigned successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $input =['book_no'  => $request->input('coupon_book_number'),
                 'start_number' => $request->input('start_number'),
                 'no_coupons'   => $request->input('number_of_coupons'),
                 'status'       => $request->input('status')
             ]  ;
             DB::table('coupon_book')->where('id',$id)->update($input);
            DB::table('coupon')->where('book_id', $id)->delete();
            $start_number = $request->input('start_number');
        $end_number = $start_number + $request->input('number_of_coupons');
        $book_id = DB::table('coupon_book')->where('book_no',$request->input('coupon_book_number'))->first()->id;
        for($i=$start_number;$i< $end_number;$i++)
        {
            $data = ['book_id'=>$book_id,'coupon_number'=>$i,'status'=>'inactive','date'=>date('Y-m-d H:i:s')];
            DB::table('coupon')->insert($data);
        }
       
        Session::flash('success', 'Coupon updated successfully!');
        return redirect()->route('coupons.index')
                        ->with('success','Coupon updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Coupon::find($id)->delete();
        Session::flash('success', 'Coupon deleted successfully!');
        return redirect()->route('coupons.index')
                        ->with('success','Coupon deleted successfully');
    }

    public function translation($id)
    {
        $coupon = Coupon::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = CouponTranslation::where('coupon_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'coupon_id' => $id,
                    'lang_code' => $row->language_code,
                    'description' => $coupon->description,
                    'created_at' => date("Y-m-d H:i:s")
                );
                CouponTranslation::insert($postData);
                $row->details = CouponTranslation::where('coupon_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('coupons.translation',compact('coupon'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'description' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'description'  => $input['description'][$i]
                );
                Coupon::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'description' => $input['description'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            CouponTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        Session::flash('success', 'Translation updated successfully!');
        return redirect()->route('coupons.index')
                        ->with('success','Translation updated successfully.');
    }

    public function changeStatus($id){
        $data = Coupon::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('coupons.index')
                        ->with('success','Status change successfully');
    }
}
