<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Currencies;
use App\Models\AppSetting;
use Illuminate\Support\Facades\Session;

class CurrencyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Currencies::orderBy('id','DESC')->get();
        return view('currencies.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        Currencies::create($input);
    
        return redirect()->route('currencies.index')
                        ->with('success','Currency created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Currencies::find($id);
    
        return view('currencies.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $currencies = Currencies::find($id);
        $currencies->update($input);
        return redirect()->route('currencies.index')
                        ->with('success','Currency updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Currencies::find($id)->delete();
        return redirect()->route('currencies.index')
                        ->with('success','Currency deleted successfully');
    }

    public function changeStatus($id){
        Currencies::where(['status' => 1])->update(array('status' => 0));
        $data = Currencies::find($id);
        $data->update(['status' => 1]);
        
        Setting::set('default_currency_code', $data->code);
        Setting::set('default_currency_decimal_digits', $data->decimal_digits);
        Setting::set('default_currency_rounding', $data->rounding);
        Setting::set('default_currency', $data->symbol);

        AppSetting::where('key','default_currency_code')->update(array('value'=>$data->code,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency_decimal_digits')->update(array('value'=>$data->decimal_digits,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency_rounding')->update(array('value'=>$data->rounding,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency')->update(array('value'=>$data->symbol,'updated_at' => date("y-m-d H:i:s")));
        Setting::save();

        Session::flash('success', 'Currency set successfully!');
        return redirect()->route('currencies.index')
                        ->with('success','Currency set successfully');
    }
}
