<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class DriverController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = User::getLists('driver');
        return view('drivers.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $user = User::where('phone', $request->input('phone'))->first();
        if($user){
            return redirect()->route('drivers.index')->with('error','Phone number is already exist.');
        }else{
            $input['password'] = Hash::make($input['password']);
            if ($image = $request->file('image')) {
                $destinationPath = public_path('app-assets/images/drivers/');
                $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $input['image'] = "$profileImage";
            }
            $driver = User::create($input);
            $driverData = array(
                'user_id'=>$driver->id,
            );    
            return redirect()->route('drivers.index')->with('success','Driver created successfully');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver = User::find($id);    
        return view('drivers.edit',compact('driver'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }

        $user = User::where('phone', $request->input('phone'))->where('id','!=',$id)->first();
        if($user){
            return redirect()->route('drivers.index')->with('error','Phone number is already exist.');
        }else{            
            $driver = User::find($id);
            if ($image = $request->file('image')) {
                $destinationPath = public_path('app-assets/images/drivers/');
                $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $input['image'] = "$profileImage";
            }else{
                unset($input['image']);
            }
            $driver->update($input);
            return redirect()->route('drivers.index')->with('success','Driver updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('drivers.index')
                        ->with('success','Driver deleted successfully');
    }

    public function changeStatus($id){
        $data = User::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('drivers.index')
                        ->with('success','Status change successfully');
    }
}
