<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class LanguagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Languages::getLists();
        return view('languages.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'language_name' => 'required',
            'language_code' => 'required',
        ]);
        $input = $request->all();
        $postData = array(
            'language_name' => $input['language_name'],
            'language_code' => $input['language_code'],
            'created_at' => date("Y-m-d H:i:s")
        );
        Languages::create($postData);
        Session::flash('success', 'Languages created successfully!');
        return redirect()->route('languages.index')
                        ->with('success','Languages created successfully.');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $languages = Languages::find($id);
        $postData = array(
            'language_name' => $input['language_name'],
            'language_code' => $input['language_code'],
            'updated_at' => date("Y-m-d H:i:s")
        );
        $languages->update($input);
        Session::flash('success', 'Languages updated successfully!');
        return redirect()->route('languages.index')
                        ->with('success','Languages updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Languages::find($id)->delete();
        Session::flash('success', 'Languages deleted successfully!');
        return redirect()->route('languages.index')
                        ->with('success','Languages deleted successfully');
    }

    public function changeStatus($id){
        $data = Languages::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('languages.index?lang_code=en')
                        ->with('success','Status change successfully');
    }
}
