<?php

namespace App\Http\Controllers;

use App\Models\Cart;
use App\Models\User;
use App\Models\UserWallet;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash; 
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = User::getLists('user');

        return view('users.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name', 'name')->all();

        return view('users.create', compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $input = $request->all();

        $input['password'] = md5($input['password']);
        $user = User::create($input);
        Session::flash('success', 'User created successfully!');

        return redirect()->route('users.index')
            ->with('success', 'User created successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);

        return view('users.edit', compact('user'));
    }

    public function getArea($id)
    {
        $empData['data'] = DB::table('areas')
            ->where('emirates_id', $id)
            ->get();

        return response()->json($empData);
    }

    public function createOrder($id)
    {
        $user = User::find($id);

        return view('users.createOrder', compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }
        $user = User::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis').'.'.$image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        } else {
            unset($input['image']);
        }
        $user->update($input);
        Session::flash('success', 'Profile updated successfully!');
        if ($user->type == 'admin') {
            return redirect()->route('users.profile')
                ->with('success', 'Profile updated successfully');
        } else {
            return redirect()->route('users.index')
                ->with('success', 'User updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        Session::flash('success', 'Profile deleted successfully!');

        return redirect()->route('users.index')
            ->with('success', 'User deleted successfully');
    }

    /**
     * Display a user profile.
     *
     * @return Response
     */
    public function profile()
    {
        $id = 1;
        $user = User::find($id);
        unset($user->password);

        return view('users.profile', compact(['user']));
    }

    public function doVerifyOtp(Request $request)
    {
        $post = $request->all();
        $this->validate($request, [
            'phone_number' => 'required',
        ]);
        $verification_code = md5($post['password']);

        $user = User::where(['phone' => $post['phone_number'], 'password' => $verification_code])->first();
        if ($user) {
            Auth::loginUsingId($user->id);
            $user = Auth::user();
            $success = [];
            $success['token'] = \Helpers::generateApiToken();

            $postUpdate = [
                'is_verified' => 1,
            ];
            User::where('id', $user->id)->update($postUpdate);
            $cartCount = Cart::where('user_id', $user->id)->count();
            Session::put('total_cart', $cartCount);

            return redirect('/profile')->with('success', 'Reply send successfully');
        } else {
            Session::flash('error', 'Login details are invalid!');

            return redirect()->back()->with('error', 'Login details are invalid!');
        }
    }

    public function changeStatus($id)
    {
        $data = User::find($id);
        if ($data->status == 1) {
            $data->update(['status' => 0]);
        } else {
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');

        return redirect()->route('users.index')
            ->with('success', 'Status change successfully');
    }

    public function userWalletLists(Request $request, $id)
    {
        $user = User::find($id);
        $data = UserWallet::getUserWalletLists($id);

        return view('users.wallet', compact('data'))->with('user', $user);
    }

    public function doSubmituserWallet(Request $request, $id)
    {
        $post = $request->all();

        request()->validate([
            'amount' => 'required',
            'description' => 'required',
            'type' => 'required',
        ]);
        $input = $request->all();

        $postData = [
            'user_id' => $id,
            'description' => $input['description'],
            'type' => $input['type'],
            'created_at' => date('Y-m-d H:i:s'),
        ];
        if ($input['type'] == 'debit') {
            $postData['amount'] = '-'.$input['amount'];
        } else {
            $postData['amount'] = $input['amount'];
        }

        UserWallet::insert($postData);

        Session::flash('success', 'Wallet transaction submited successfully!');

        return redirect()->back()->with('success', 'Wallet transaction submited successfully!');
    }
}
