<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    public function product(){
        return $this->hasOne('\App\Models\Product','id','product_id');
    }

    protected $fillable = [
        'product_id',
        'user_id',
        'quantity',
        'amount',
        'total_amount',
        'no_of_delivery',
        'order_frequency',
        'days',
        'start_date',
        'end_date'
    ];
}
