<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasFactory;

    public $fillable = [
        'coupon_name',
        'type',
        'value',
        'start_date',
        'end_date',        
        'minimum_order_value',
        'image',
        'status',
        'description'
    ];

    public static function getLists()
    {
        try {
          $query = new Self;
          $data = $query->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
          return $data;
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}
