<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Exports\OrdersExport;
use Maatwebsite\Excel\Facades\Excel;

class OrderProductsDelivery extends Model
{
    use HasFactory;

    public $table = 'orders_products_delivery';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'user_id',
        'order_status_id',
        'order_id',
        'product_order_id',
        'delivery_date',
        'product_id'
    ];
    
    public function product_orders()
    {
        return $this->hasOne('\App\Models\OrderProduct','id','product_order_id')->with('product');
    }

    public function delivery_status()
    {
        return $this->hasOne('\App\Models\OrderStatus','id','order_status_id');
    }

    public function user()
    {
        return $this->hasOne('\App\Models\User','id','user_id');
    }

    public function driver()
    {
        return $this->hasOne('\App\Models\User','id','driver_id');
    }

    public function order()
    {
        return $this->hasOne('\App\Models\Order','id','order_id')->with('delivery_address');
    }

    public static function getLists($search)
    {
        try {
            $query = new Self;
            if(isset($_GET['submit'])){

                if(isset($_GET['user_id']) && $_GET['user_id']!=''){
                    $query = $query->where('user_id',$_GET['user_id']);
                }

                if(isset($_GET['order_date']) && $_GET['order_date']!=''){
                    $query = $query->where('delivery_date', date('Y-m-d',strtotime($_GET['order_date'])));
                }

                if(isset($_GET['order_status_id']) && $_GET['order_status_id']!=''){
                    $query = $query->where('order_status_id',$_GET['order_status_id']);
                }

                return $query->with("user")->with("delivery_status")->with('product_orders')->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('user')->with('delivery_status')->with('product_orders')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }

    public static function getReport($search)
    {
        try {
            $query = new Self;
            
            if(isset($_GET['submit'])){
                if(isset($_GET['date_filter']) && $_GET['date_filter']!=''){
                    $parts = explode(' to ' , $_GET['date_filter']);
                    $date_from = trim($parts[0]);
                    $date_to = trim($parts[1]);
                    $obj = $query->where('delivery_date', '>=',date('Y-m-d',strtotime($date_from)))->where('delivery_date', '<=',date('Y-m-d',strtotime($date_to)));
                }
                
                return $obj->with("user")->with("delivery_status")->with('product_orders')->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));
            }else{
                $data = $query->with('user')->with('delivery_status')->with('product_orders')->orderBy('id','DESC')->paginate(config('constant.paginate.num_per_page'));
                return $data;
            }
        }catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
}