@extends('layouts.app')
@section('content')

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="{{asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')}}"></script>
<link rel="stylesheet" type="text/css" href="{{asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')}}" />

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_coupon')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/coupons*') ? 'active' : '' }}"><a href="{!! route('coupons.index') !!}">{{__('lang.admin_coupon_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">Assign Coupon
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <!-- users edit start -->
                                @foreach($coupon as $c)
                                <form class="add-new-record modal-content pt-0" action="{!! url('admin/coupon/assigned/'.$id) !!}" method="post">
                                @csrf
                               
                                <!-- coupons edit ends -->
                                <!-- coupons edit form start -->
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">Coupon Book Number</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_coupon_name')}}" value="{{$number}}" name="coupon_book_number" id="coupon_name" readonly  required/>
                                        </div>
                                    </div>
                                    
                                  
                                    
                                    
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="user" name="user" required>
                                                @foreach($customer as $cust)
                                                <option value="{{$cust->id}}" >{{$cust->name}}</option>

                                                @endforeach
                                                
                                            </select>
                                        </div>
                                    </div>
                                   
                                   
                                    
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('coupons.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                </form>
                                @endforeach
                                <!-- coupons edit form ends -->
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>
            <!-- coupons edit ends -->

        </div>
    </div>
</div>

<script type="text/javascript">
    var basicPickr = $('.flatpickr-basic');
    basicPickr.flatpickr();
</script>
<!-- END: Content-->
@endsection