<div class="content-body">
     <!-- Striped rows start -->
     <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Coupons List</h4>
                    
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>S.No.</th>
                                <th>Coupon Book Number</th>
                                <th>No of Coupon</th>
                                <th>Coupon Range</th>
                                <th>Assigned To</th>
                                <th>Status</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $m = 1;
                            ?>
                            @if(count($coupons) > 0)
                            @foreach($coupons as $res)
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                   
                                </span>{{$m}}</span></td>
                                <td>{{$res->book_no}}</td>
                                <td>{{$res->no_coupons}}</td>
                                <td>{{$res->start_number}}-{{$res->start_number+$res->no_coupons-1}}</td>
                                <?php
                                if($res->assigned != null)
                                {
                                    $name = DB::table('users')->where('id',$res->assigned)->first()->name;
                                }
                                else
                                {
                                    $name= "Free";
                                }
                                
                                ?>
                                <td style="text-transform:capitalize; <?php if($name != 'Free'){echo "font-weight:bold;color:green;";} ?>;">{{$name}}</td>
                                <td>{{$res->status}}</td>
                               
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ url('admin/coupons/assign/'.$res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>Assign</span>
                                            </a>
                                            <a class="dropdown-item" href="{{ route('coupons.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a>
                                            <a class="dropdown-item" href="">
                                                <i data-feather="type" class="me-50"></i>
                                                <span>{{__('lang.admin_button_translation')}}</span>
                                            </a>
                                            
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php 
                            $m = $m+1;
                            ?>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>