@extends('layouts.app')
@section('content')

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_delivery_areas')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/delivery_areas*') ? 'active' : '' }}"><a href="{!! route('delivery_areas.index') !!}">{{__('lang.admin_delivery_area_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_delivery_area_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <!-- users edit start -->
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <!-- Account Tab starts -->
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($data, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['delivery_areas.update', $data->id]]) !!}
                                @csrf
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_location_name')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_location_name')}}" value="{{$data->location_name}}" name="location_name" id="location_name" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="zip_code">{{__('lang.admin_zip_code')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_zip_code')}}" value="{{$data->zip_code}}" name="zip_code" id="zip_code" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($data->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($data->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('delivery_areas.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                            <!-- Account Tab ends -->
                        </div>
                    </div>
                </div>
            </section>

        </div>
    </div>
</div>
<script type="text/javascript">
    setTimeout(function(){
        googleAutoComplete(); 
    },1000);
</script>
@endsection