<style type="text/css">
    .table-responsive{
        min-height: auto;
    }
</style>
<div class="table-responsive">
    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>{{__('lang.admin_order_item_name')}}</th>
                <th>{{__('lang.admin_order_delivery')}}</th>
                <th>{{__('lang.admin_order_delivery_date')}}</th>
                <th>{{__('lang.admin_start_date')}}</th>
                <th>{{__('lang.admin_end_date')}}</th>
                <th>{{__('lang.admin_price')}}</th>
                <th>{{__('lang.admin_order_quantity')}}</th>
                <th>{{__('lang.admin_amount')}}</th>
            </tr>
        </thead>
        <tbody>
            <?php $i = 1; ?>
            @if(count($data->product_orders) > 0)
            @foreach($data->product_orders as $res)
            <tr>
                <td>{{$i}}</td>
                <td>{{isset($res->product->name)?$res->product->name:'--' }}</td>
                <td style="text-transform: capitalize;">{{isset($res->order_frequency) ? $res->order_frequency : '--' }}</td>
                @if($res->order_frequency == 'once')
                <td>
                    @if(isset($res->end_date))
                        {{\Helpers::commonDateFormate($res->end_date)}}
                    @else
                        @if($res->product_deliverys)
                            @if((isset($res->product_deliverys[count($res->product_deliverys)-1])))
                                {{\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)}}
                            @else
                                --
                            @endif
                        @else
                            --
                        @endif
                    @endif
                </td>
                @else 
                <td>
                    <button class="dropdown-item" data-bs-toggle="modal" data-bs-target="#modalsDates_{{$res->id}}">
                        <i data-feather="eye" class="me-50"></i>
                        <span>View All</span>
                    </button>
                    <div class="modal fade text-start" id="modalsDates_{{$res->id}}" tabindex="-1" aria-labelledby="myModalLabel160" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-xs">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="myModalLabel160">Delivery Dates</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    @foreach($res->product_deliverys as $deliveries)
                                    <ul class="list-group">
                                        <li class="list-group-item">{{\Helpers::commonDateFormate($deliveries->delivery_date)}} <small class="text-right">{{$deliveries->delivery_status->status}}</small></li>
                                    </ul>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </td>
                @endif
                <td>
                    @if(isset($res->start_date))
                        {{\Helpers::commonDateFormate($res->start_date)}}
                    @else
                        @if(isset($res->product_deliverys[0]))
                            {{\Helpers::commonDateFormate($res->product_deliverys[0]->delivery_date)}}
                        @else
                            --
                        @endif
                    @endif
                </td>

                <td>
                    @if(isset($res->end_date))
                        {{\Helpers::commonDateFormate($res->end_date)}}
                    @else
                        @if($res->product_deliverys)
                            @if(isset($res->product_deliverys[count($res->product_deliverys)-1]))
                                {{\Helpers::commonDateFormate($res->product_deliverys[count($res->product_deliverys)-1]->delivery_date)}}
                            @else
                                --
                            @endif
                        @else
                            --
                        @endif
                    @endif
                </td>

                <td>
                    @if(isset($res->per_delivery_amount))
                        {{\Helpers::currency($res->per_delivery_amount)}}
                    @else
                        --
                    @endif
                </td>

                <td>{{$res->quantity}}</td>
                <td>{{\Helpers::currency($res->total_delivery_amount)}}</td>
            </tr>
            <?php $i++; ?>
            @endforeach
            @else
            <tr>
                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
<div class="row">
    <div class="col-5 offset-7">
        <div class="table-responsive table-light">
            <table class="table">
                <tbody>
                    <tr>
                        <th class="text-right">{{__('lang.admin_sub_total')}}</th>
                        <td>{{\Helpers::currency($data->subtotal)}}</td>
                    </tr>
                    @if($data->promotional_disount>0)
                    <tr>
                        <th class="text-right">{{__('lang.admin_discount')}} ({{ isset($data->coupon_code) ? $data->coupon_code : '--' }})</th>
                        <td style="color:red">-{{\Helpers::currency($data->promotional_disount)}}</td>
                    </tr>
                    @endif
                    <tr>
                        <th class="text-right">{{__('lang.admin_delivery_fee')}}</th>
                        <td>{{\Helpers::currency($data->delivery_fee)}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">{{__('lang.admin_tax')}}</th>
                        <td>{{\Helpers::currency($data->tax)}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">{{__('lang.admin_final_amnt')}}</th>
                        <td><b>{{\Helpers::currency($data->final_amount)}}</b></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>