<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped"> 
        <div class="col-12"> 
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{__('lang.admin_menu_orders_list')}}</h4>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{__('lang.admin_order_id')}}</th>
                                <th>Name</th>
                                <th>{{__('lang.admin_user_phone')}}</th>
                                <th>{{__('lang.admin_order_status')}}</th>
                                <th>Driver Assigned</th>
                                <th>{{__('lang.admin_table_action')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($data) > 0)
                            @foreach($data as $res)
                            <?php
                            $phone = DB::table('users')->where('id',$res->user_id)->first()->phone;;
                            $name = DB::table('users')->where('id',$res->user_id)->first()->name;;
                            ?>
                            
                            <tr>
                                <?php
                                    if($res->driver_id > 0){
                                     $driver = DB::table('users')->where('id',$res->driver_id)->first()->name;
                                    }
                                    else
                                    {
                                        $driver = '--';
                                    }
                                                                  
                            ?>
                                <td><a title="Order Detail" href="{{ route('orders.show', $res->id)}}">{{$res->id}}</a></td>
                                <td>{{ $name }}</td>
                                <td>{{ $phone }}</td>
                                <td>{{ isset($res->order_status) ? $res->order_status : '--' }}</td>
                                <td>{{$driver}}</td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('orders.show', $res->id) }}">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>{{__('lang.admin_button_detail')}}</span>
                                            </a>
                                            <a class="dropdown-item" href="{{ URL('admin/assignDriver/'.$res->id )}}">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>assign Driver</span>
                                            </a>
                                           <!--  <a class="dropdown-item" href="{{ route('orders.edit', $res->id) }}">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span>{{__('lang.admin_button_edit')}}</span>
                                            </a> -->
                                            {!! Form::open(['route' => ['orders.destroy', $res->id], 'method' => 'delete']) !!}
                                            {!! Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]) !!}
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="8" class="recordnotfound"><span>{{__('lang.admin_message_no_result_found')}}</span></td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>