@extends('layouts.site-app') @section('sitecontent')

<section class="headerbg headerbg-inner">
    <div class="container">
        <div class="header">
            @include('partials.site.header-menu')
        </div>

        <div class="inner-heading">{{__('lang.navigation_payment')}}</div>
    </div>
</section>

<section class="order-details-bg paymentform-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                @include('partials.site.user-links')
            </div>

            <div class="col-lg-9 col-md-8">
                <div>
                    @include('partials.site.alert')
                </div>

                <div class="cardbox">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="addcard">
                                <div class="custom-file">
                                    <a href="javascript:;" onclick="showCardForm();">
                                        <label class="custom-file-label" for="exampleInputFile">
                                            <img src="{{asset('site-assets/images/addcard-icon.png')}}" />

                                            <h6>{{__('lang.Payment_add_card')}}</h6>
                                        </label>
                                    </a>
                                </div>
                            </div>
                        </div>
                        @foreach($data as $card)
                        <div class="col-md-6">
                            <div class="cardimg">
                                <div class="cardno">
                                    <a onclick="return confirm('Are you sure you want to delete this card?');" href="{{url('/card-address')}}/{{$card->id}}"><img src="{{asset('site-assets/images/delete-icon.png')}}" /></a>
                                    <ul>
                                        <li>****</li>
                                        <li>****</li>
                                        <li>****</li>
                                        <li>{{substr($card->card_no,12)}}</li>
                                    </ul>
                                </div>
                                <div class="cardnme">{{$card->card_holder_name}}</div>
                                <div class="carddat">{{$card->month}}/{{$card->year}}</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>

                <div class="loginform paymentform" id="addCardForm" style="display: none;">
                    <form id="addCard" method="post" enctype="multipart/form-data" action="{{url('/add-card')}}">
                        {{ csrf_field() }}

                        <input type="hidden" name="user_id" value="{{$user_id}}" />

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span><img src="{{asset('site-assets/images/user_wall.svg')}}" /></span>
                                <input type="text" class="form-control" placeholder="{{__('lang.Payment_cardholder_name')}}" name="card_holder_name" />
                            </div>
                            <div class="form-group col-md-3">
                                <span><img src="{{asset('site-assets/images/pay_new.svg')}}" /></span>
                                <select class="form-control" name="card_type">
                                    <option value="VISA">VISA</option>
                                    <option value="MASTER">MASTER</option>
                                    <option value="MADA">MADA</option>
                                </select>
                            </div>
                            <div class="form-group col-md-9">
                                <span><img src="{{asset('site-assets/images/pay_new.svg')}}" /></span>
                                <input
                                    type="text"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    class="form-control"
                                    placeholder="{{__('lang.Payment_card_number')}}"
                                    name="card_no"
                                />
                            </div>
                            <div class="form-group col-md-6">
                                <span><img src="{{asset('site-assets/images/expdate-icon.svg')}}" /></span>
                                <input
                                    type="text"
                                    class="form-control"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    placeholder="{{__('lang.Payment_card_expiry_month')}}"
                                    name="month"
                                />
                            </div>
                            <div class="form-group col-md-6">
                                <span><img src="{{asset('site-assets/images/expdate-icon.svg')}}" /></span>
                                <input
                                    type="text"
                                    class="form-control"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    placeholder="{{__('lang.Payment_card_expiry_year')}}"
                                    name="year"
                                />
                            </div>
                            <div class="form-group col-md-12">
                                <span><img src="{{asset('site-assets/images/sefty.svg')}}" /></span>
                                <input
                                    type="text"
                                    onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                    class="form-control"
                                    placeholder="{{__('lang.Payment_card_security_code')}}"
                                    name="cvv"
                                />
                            </div>
                        </div>

                        <div class="savebtn">
                            <a href="javascript:;" onclick="event.preventDefault(); document.getElementById('addCard').submit();"><img src="{{asset('site-assets/images/arrowright.png')}}" /> {{__('lang.save_button')}}</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<footer class="footer">
    @include('partials.site.footer')
</footer>

<!-- END: Content-->

@endsection