@extends('layouts.app')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_settings')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_menu_website_settings')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model(null, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'url' => ['admin/settings/update']]) !!}
                                    @csrf                                    
                                    <div class="row">
                                        @foreach ($data as $row)
                                            @if($row->key=='youtube_video_url')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="youtube_video_url">{{__('lang.admin_youtube_embed_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_youtube_embed_url')}}" name="youtube_video_url" id="youtube_video_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='apple_download_url')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="apple_download_url">{{__('lang.admin_apple_download_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_apple_download_url')}}" name="apple_download_url" id="apple_download_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='android_download_url')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="android_download_url">{{__('lang.admin_android_download_url')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_android_download_url')}}" name="android_download_url" id="android_download_url" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_phone')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_phone">{{__('lang.admin_contact_phone')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_phone')}}" name="contact_phone" id="contact_phone" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_email')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_email">{{__('lang.admin_contact_email')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_email')}}" name="contact_email" id="contact_email" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_address')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_address">{{__('lang.admin_contact_address')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_address')}}" name="contact_address" id="contact_address" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif
                                            @if($row->key=='contact_support_phone')
                                                <div class="col-md-4">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="contact_support_phone">{{__('lang.admin_contact_support_phone')}}</label>
                                                        <input type="text" class="form-control" placeholder="{{__('lang.admin_contact_support_phone')}}" name="contact_support_phone" id="contact_support_phone" value="{{$row->value}}" />
                                                    </div>
                                                </div>
                                            @endif

                                        @if($row->key=='site_title')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="site_title">{{__('lang.admin_seo_title')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_title')}}" name="site_title" id="site_title" value="{{$row->value}}" />
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='site_author')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="site_author">{{__('lang.admin_seo_author')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_author')}}" name="site_author" id="site_author" value="{{$row->value}}" />
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='site_description')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="site_description">{{__('lang.admin_seo_description')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_description')}}" name="site_description" id="site_description" value="{{$row->value}}" />
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='site_keyword')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="site_keyword">{{__('lang.admin_seo_keyword')}}</label>
                                                <input type="text" class="form-control" placeholder="{{__('lang.admin_seo_keyword')}}" name="site_keyword" id="site_keyword" value="{{$row->value}}" />
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='google_analysis')
                                        <div class="col-md-4">
                                            <div class="mb-1">
                                                <label class="form-label" for="google_analysis">{{__('lang.admin_google_analysis')}}</label>
                                                <textarea class="form-control" placeholder="{{__('lang.admin_google_analysis')}}" name="google_analysis" id="google_analysis">{{$row->value}}</textarea>
                                            </div>
                                        </div>
                                        @endif
                                        @if($row->key=='website_logo')
                                        <div class="col-md-4">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_website_logo')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Logo" class="website_logo users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Website Logo" class="website_logo users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="website_logo">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="website_logo" hidden accept="image/png, image/jpeg, image/jpg" name="website_logo"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='about_product')
                                        <div class="col-md-4">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_about_product')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="About Product" id="about_product_src" class="about_product users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="About Product" id="about_product_src" class="about_product users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="about_product">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="about_product" hidden accept="image/png, image/jpeg, image/jpg" name="about_product"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif
                                        
                                        @if($row->key=='mobile_image')
                                        <div class="col-md-4">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_mobile_image')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Mobile Image" id="mobile_image_img" class="mobile_image users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Mobile Image" id="mobile_image_img" class="mobile_image users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="mobile_image">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="mobile_image" hidden accept="image/png, image/jpeg, image/jpg" name="mobile_image"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        

                                        
                                        @if($row->key=='icon_1')
                                        <div class="col-md-3">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_website_icon1')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Icon 1" class="icon_1 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Website Icon 1" class="icon_1 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="icon_1">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="icon_1" hidden accept="image/png, image/jpeg, image/jpg" name="icon_1"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_2')
                                        <div class="col-md-3">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_website_icon2')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Icon 2" class="icon_2 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Website Icon 2" class="icon_2 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="icon_2">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="icon_2" hidden accept="image/png, image/jpeg, image/jpg" name="icon_2"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_3')
                                        <div class="col-md-3">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_website_icon3')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Icon 3" class="icon_3 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Website Icon 3" class="icon_3 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="icon_3">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="icon_3" hidden accept="image/png, image/jpeg, image/jpg" name="icon_3"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        @if($row->key=='icon_4')
                                        <div class="col-md-3">
                                            <label class="form-label" for="google_analysis">{{__('lang.admin_website_icon4')}}</label>
                                            <div class="mb-1">
                                                @if($row->value!='')
                                                    <img src="{{asset('site-assets/images/website/'.$row->value)}}" alt="Website Icon 4" class="icon_4 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('site-assets/images/no-image.png')}}';"/>
                                                @else
                                                <img src="{{asset('site-assets/images/no-image.png')}}" alt="Website Icon 4" class="icon_4 users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                                @endif
                                                <br>
                                                <label class="btn btn-primary me-75 mb-0" for="icon_4">
                                                    <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                    <input class="form-control" type="file" id="icon_4" hidden accept="image/png, image/jpeg, image/jpg" name="icon_4"/>
                                                    <span class="d-block d-sm-none">
                                                        <i class="me-0" data-feather="edit"></i>
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif

                                        

                                        @endforeach
                                        <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                            <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        </div>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection