@extends('layouts.app')
@section('content')
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0">{{__('lang.admin_menu_users')}}</h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{!! route('dashboard')!!}">{{__('lang.admin_menu_dashboard')}}</a>
                                </li>
                                <li class="breadcrumb-item {{ Request::is('admin/users*') ? 'active' : '' }}"><a href="{!! route('users.index') !!}">{{__('lang.admin_user_list')}}</a>
                                </li>
                                <li class="breadcrumb-item active">{{__('lang.admin_user_info')}}
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                {!! Form::model($user, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['users.update', $user->id]]) !!}
                                @csrf
                                <div class="d-flex mb-2">
                                    @if($user->image)
                                    <img src="{{asset('app-assets/images/users/'.$user->image)}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='{{asset('app-assets/images/no-image.png')}}';"/>
                                    @else
                                    <img src="{{asset('app-assets/images/no-image.png')}}" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    @endif
                                    <div class="mt-50">
                                    <h4>{{$user->name}}</h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block">{{__('lang.admin_button_upload')}}</span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username">{{__('lang.admin_user_name')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_user_name')}}" value="{{$user->name}}" name="name" id="username" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email">{{__('lang.admin_email')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_email')}}" value="{{$user->email}}" name="email" id="email" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="phone">{{__('lang.admin_user_phone')}}</label>
                                            <input type="text" class="form-control" placeholder="{{__('lang.admin_user_phone')}}" value="{{$user->phone}}" name="phone" id="phone" />
                                        </div>
                                    </div>
                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Choose Emirates</label>
                    <?php
                    $emirates = DB::table('emirates')->get();
                    $a = 0;

                    $em_id =$user->emirates;
                    if($em_id != null)
                    {
                        $em  = DB::table('emirates')->where('id',$em_id)->first()->name;
                        $ar = DB::table('areas')->where('emirates_id',$em_id)->where('id',$user->area)->first()->name;
                        $a = 1;
                    }
                    
                    ?>
                    <select class="form-select" name="emirates" id="emirates">
                        <?php 
                        if($a ==0)
                        {
                        ?>
                        <option>Please Select</option>
                        <?php 
                        }
                        else
                        {
                        ?>
                        <option value="{{$em_id}}">{{$em}}</option>
                        <?php
                        }
                        ?>
                        @foreach($emirates as $em)
                        <option value="{{$em->id}}">{{$em->name}}</option>
                        @endforeach
                    </select>
                </div>
                </div>

                <div class="col-md-4">

                 <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Choose Area</label>
                    
                    <select class="form-select" name="area" id="area">
                        <?php 
                        if($a ==0)
                        {
                        ?>
                        <option>Please Select</option>
                        <?php 
                        }
                        else
                        {
                        ?>
                        <option value="{{$user->area}}">{{$ar}}</option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
                </div>

                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Building Name/Number</label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="Building Name" aria-label="john.doe@example.com" name="building" value="{{$user->building}}" />
                    
                </div>
                </div>
                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Flat Number</label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="Flat Number" aria-label="john.doe@example.com" name="flat_no" value="{{$user->flat_no}}" />
                    
                </div>
                </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="password">{{__('lang.admin_password')}}</label>
                                            <input type="password" class="form-control" placeholder="{{__('lang.admin_password')}}" name="password" id="password"  />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status">{{__('lang.admin_status')}}</label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" @if($user->status == 1) selected  @endif>{{__('lang.admin_active')}}</option>
                                                <option value="0" @if($user->status == 0) selected  @endif>{{__('lang.admin_deactive')}}</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1">{{__('lang.admin_button_save_changes')}}</button>
                                        <a href="{!! route('users.index') !!}" class="btn btn-outline-secondary">{{__('lang.admin_button_back')}}</a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script type='text/javascript'>

    $(document).ready(function(){



      $('#emirates').change(function(){

         // Department id
         var id = $(this).val();
         var currentUrl = window.location.href;
         var segments = currentUrl.split('/');
         var newSegments = segments.slice(0, -4);
         var newUrl = newSegments.join('/');

         // Empty the dropdown
         $('#area').find('option').not(':first').remove();

         // AJAX request
         $.ajax({
           url: newUrl+'/getArea/'+id,
           type: 'get',
           dataType: 'json',
           success: function(response){

             var len = 0;
             if(response['data'] != null){
               len = response['data'].length;
             }

             if(len > 0){
               // Read data and create <option >
               for(var i=0; i<len; i++){

                 var id = response['data'][i].id;
                 var name = response['data'][i].name;

                 var option = "<option value='"+id+"'>"+name+"</option>";

                 $("#area").append(option);
               }


             }

           }
        });
      });




    });

    </script>
@endsection