<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/




Route::get('keys-lists', 'App\Http\Controllers\API\LanguagesAPIController@keysLists');
Route::post('addNewKeys', 'App\Http\Controllers\API\LanguagesAPIController@addNewKeys');
Route::get('app-setting', 'App\Http\Controllers\API\UserAPIController@settings');
Route::post('user/login', 'App\Http\Controllers\API\UserAPIController@doLogin');
Route::post('user/verify-otp', 'App\Http\Controllers\API\UserAPIController@doVerifyOtp');
Route::post('user/resend-otp', 'App\Http\Controllers\API\UserAPIController@doResndOtp');
Route::get('home-product-list', 'App\Http\Controllers\API\ProductAPIController@index');
Route::get('product-details/{id}', 'App\Http\Controllers\API\ProductAPIController@productDetails');
Route::post('search-product', 'App\Http\Controllers\API\ProductAPIController@search');
Route::get('order/pending/lists/{token}', 'App\Http\Controllers\API\OrdersAPIController@pendingList');
Route::get('order/detail/{id}/{token}', 'App\Http\Controllers\API\OrdersAPIController@details');
Route::get('order/history/lists/{token}', 'App\Http\Controllers\API\OrdersAPIController@historyList');
Route::get('order/statusupdate/{id}/{token}/{status}', 'App\Http\Controllers\API\OrdersAPIController@statusUpdate');

Route::post('customer/signup', 'App\Http\Controllers\API\UserAPIController@doCustSign');
Route::post('customer/createorder', 'App\Http\Controllers\API\OrdersAPIController@createOrder');
Route::get('customerorder/lists/{token}', 'App\Http\Controllers\API\OrdersAPIController@customerOrderList');

Route::post('customerorder/detail/', 'App\Http\Controllers\API\OrdersAPIController@customerOrderDetails');

Route::post('customerdelivery/locationupdate/', 'App\Http\Controllers\API\OrdersAPIController@deliveryLocationUpdate');

Route::post('getemirates/', 'App\Http\Controllers\API\UserAPIController@getEmirates');
Route::post('getarea/', 'App\Http\Controllers\API\UserAPIController@getArea');
Route::post('custlogin/', 'App\Http\Controllers\API\UserAPIController@custLogin');

Route::post('customer/couponlists', 'App\Http\Controllers\API\CouponAPIController@assignedCoupons');
Route::post('customer/couponsheet', 'App\Http\Controllers\API\CouponAPIController@assignedCouponSheet');


 
//driver
Route::post('driver/login', 'App\Http\Controllers\API\UserAPIController@doDriverLogin');
Route::get('driver/profile/{token}', 'App\Http\Controllers\API\UserAPIController@driverProfile');
Route::get('customer/profile/{token}', 'App\Http\Controllers\API\UserAPIController@customerProfile');
Route::get('driver/logout/{token}', 'App\Http\Controllers\API\UserAPIController@driverLogout');
//Route::post('driver/forgot-password/request', 'API\UserAPIController@doDriverForgotPassword');
//Route::post('driver/confirm-forgot-password', 'API\UserAPIController@doConfirmForgotPassword');

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::middleware('apiauth:api')->group(function () {
    Route::prefix('driver')->group(function () {
        Route::get('profile', 'App\Http\Controllers\API\UserAPIController@getDriverProfile');
        Route::post('update-profile', 'App\Http\Controllers\API\UserAPIController@doUpdateDriverProfile');
        Route::post('logout', 'App\Http\Controllers\API\UserAPIController@doDriverLogout');

        Route::get('notification/list', 'App\Http\Controllers\API\NotificationAPIController@getDriverNotificationList');
        Route::get('notification/delete/all', 'App\Http\Controllers\API\NotificationAPIController@deleteAllDriverNotification');
        Route::get('notification/count', 'App\Http\Controllers\API\NotificationAPIController@getDriverNotificationCount');

        Route::get('order/list', 'App\Http\Controllers\API\OrdersAPIController@getDriverAssignedOrderList');
        Route::get('order/detail/{id}', 'App\Http\Controllers\API\OrdersAPIController@getDriverAssignedOrderDetail');
        Route::post('order/change-status/{id}', 'App\Http\Controllers\API\OrdersAPIController@changeOrderStatus');
        Route::get('order/all-status', 'App\Http\Controllers\API\OrdersAPIController@orderStatusList');
    });

    Route::post('user/logout', 'App\Http\Controllers\API\UserAPIController@doLogout');

    Route::get('offers/coupon-lists', 'App\Http\Controllers\API\CouponAPIController@couponLists');
    Route::post('offers/verify-code', 'App\Http\Controllers\API\CouponAPIController@doVerifyCode');

    Route::get('user/get-profile', 'App\Http\Controllers\API\UserAPIController@getProfile');
    Route::post('user/update-profile', 'App\Http\Controllers\API\UserAPIController@doUpdateProfile');
    Route::post('user/update-notification', 'App\Http\Controllers\API\UserAPIController@doUpdateNotification');

    Route::post('cart/add-update', 'App\Http\Controllers\API\CartAPIController@addtoCart');
    Route::post('cart/bulk-add', 'App\Http\Controllers\API\CartAPIController@bulkAddtoCart');
    Route::get('cart/list', 'App\Http\Controllers\API\CartAPIController@getCartData');
    Route::post('cart/delete', 'App\Http\Controllers\API\CartAPIController@deleteitemCart');
    Route::get('carts/count', 'App\Http\Controllers\API\CartAPIController@count');

    Route::get('card/list', 'App\Http\Controllers\API\CardDetailAPIController@listCardDetails');
    Route::post('card/add-update', 'App\Http\Controllers\API\CardDetailAPIController@addUpdateUserCardDetail');
    Route::post('card/delete/{id}', 'App\Http\Controllers\API\CardDetailAPIController@deleteUserCard');
    Route::post('card/set-default/{id}', 'App\Http\Controllers\API\CardDetailAPIController@setDefaultUserCard');

    Route::get('address/list', 'App\Http\Controllers\API\UserAPIController@listUserAddress');
    Route::post('address/add-update', 'App\Http\Controllers\API\UserAPIController@addUpdateUserAddress');
    Route::post('address/delete/{id}', 'App\Http\Controllers\API\UserAPIController@deleteUserAddress');
    Route::post('address/set-default/{id}', 'App\Http\Controllers\API\UserAPIController@setDefaultUserAddress');

    Route::get('wallet-history', 'App\Http\Controllers\API\UserWalletAPIController@list');
    Route::post('add-wallet-amount', 'App\Http\Controllers\API\UserWalletAPIController@addWalletAmount');
    Route::get('my-wallet-amount', 'App\Http\Controllers\API\UserWalletAPIController@walletAmountOfuser');

    Route::get('my-payment-history', 'App\Http\Controllers\API\PaymentAPIController@list');

    Route::post('contect-us', 'App\Http\Controllers\API\ContactusAPIController@doSubmit');

    Route::post('order/place', 'App\Http\Controllers\API\OrdersAPIController@placeOrder');
    Route::get('order/lists', 'App\Http\Controllers\API\OrdersAPIController@list');

    Route::get('order/cancel-request/{id}', 'App\Http\Controllers\API\OrdersAPIController@orderCancelRequest');

    Route::get('notification', 'App\Http\Controllers\API\NotificationAPIController@index');
    Route::get('notification/count', 'App\Http\Controllers\API\NotificationAPIController@unreadCount');
    Route::post('notification/{id}', 'App\Http\Controllers\API\NotificationAPIController@update');
    Route::get('notification/delete', 'App\Http\Controllers\API\NotificationAPIController@destroy');
});
