<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('clear', function() {
  Artisan::call('cache:clear');
  Artisan::call('config:clear');
  Artisan::call('config:cache');
  Artisan::call('view:clear');
  return "Cleared!";
});

Route::get('/getArea/{id}', 'App\Http\Controllers\UserController@getArea');

Route::middleware('checkauth:web')->group(function () {
    Route::get('/signin', 'App\Http\Controllers\SiteController@signin');
    Route::post('/verify-otp', 'App\Http\Controllers\UserController@doVerifyOtp');
    Route::get('/signup', 'App\Http\Controllers\SiteController@signup');
});


Route::middleware('language:web')->group(function () {
    Route::get('/website', 'App\Http\Controllers\SiteController@index');    
    Route::get('/contact-us', 'App\Http\Controllers\SiteController@contact');
    Route::post('/contact-us', 'App\Http\Controllers\SiteController@doSubmitContactUs');
    Route::get('/privacy-policy', 'App\Http\Controllers\SiteController@privacyPolicy');
    Route::get('/term-and-conditions', 'App\Http\Controllers\SiteController@termsAndCondition');
    Route::get('/about', 'App\Http\Controllers\SiteController@about');
    Route::get('/account-delete', 'App\Http\Controllers\SiteController@accountDelete');
});

Route::middleware('siteauth:web')->group(function () {
    Route::get('/cart', 'App\Http\Controllers\SiteController@cart');
    Route::get('/add-to-cart', 'App\Http\Controllers\SiteController@addToCart');
    Route::get('/delete-cart-item/{id}', 'App\Http\Controllers\SiteController@deleteCartitem');
    Route::post('/cart-checkout', 'App\Http\Controllers\SiteController@doCheckout');
    Route::get('/apply-coupon', 'App\Http\Controllers\SiteController@applyCoupon');
    Route::get('/checkout', 'App\Http\Controllers\SiteController@checkout');
    Route::get('/place-order', 'App\Http\Controllers\SiteController@placeOrder');
    Route::post('/do-place-order', 'App\Http\Controllers\SiteController@doPlaceOrder');
    Route::get('/do-online-payment/{id}', 'App\Http\Controllers\SiteController@doOnlinePayment');
    Route::get('/do-confirm-payment/{id}', 'App\Http\Controllers\SiteController@doConfirmPayment');
    
    Route::get('/profile', 'App\Http\Controllers\SiteController@profile');
    Route::get('/orders', 'App\Http\Controllers\SiteController@orders');
    Route::get('/order-details/{id}', 'App\Http\Controllers\SiteController@orderDetail');
    Route::get('/cancel-order-request/{id}', 'App\Http\Controllers\SiteController@cancelOrderRequest');
    
    Route::post('/user-logout', 'App\Http\Controllers\SiteController@userLogout');
    Route::post('/user-terminate', 'App\Http\Controllers\SiteController@userTerminate');
    Route::post('/update-profile', 'App\Http\Controllers\SiteController@updateProfile');
    Route::post('/add-card', 'App\Http\Controllers\SiteController@addCard');

    Route::get('/addresses', 'App\Http\Controllers\SiteController@addresses');
    Route::get('/delete-address/{address_id}', 'App\Http\Controllers\SiteController@deleteMyAddress');
    Route::post('/add-address', 'App\Http\Controllers\SiteController@addUpdateAddress');

    Route::get('/wallet', 'App\Http\Controllers\SiteController@wallet');
    Route::post('/wallet-checkout', 'App\Http\Controllers\SiteController@submitWallet');
    Route::post('/wallet-payment-confirm', 'App\Http\Controllers\SiteController@doConfirmWalletPayment');
});

Route::get('/set-language', 'App\Http\Controllers\SiteController@setLanguage');
Route::post('makeOrders','App\Http\Controllers\OrderController@makeOrder');
Route::post('assignOrders','App\Http\Controllers\OrderController@assignOrder');

/*
    Admin ROUTES
*/
Route::middleware('admin-language:web')->group(function () {
    Route::get('/','App\Http\Controllers\Auth\LoginController@getLoginView');
    Route::get('/admin-login','App\Http\Controllers\Auth\LoginController@getLoginView');
    Route::post('do-login', 'App\Http\Controllers\Auth\LoginController@authenticate');
    Route::get('logout', 'App\Http\Controllers\Auth\LoginController@logout');

    Route::middleware('auth')->group(function () {
        Route::post('users/store', 'App\Http\Controllers\UserController@store')->name('users.create');
        Route::post('products/store', 'App\Http\Controllers\ProductController@store')->name('products.create');
        Route::get('users/profile', 'App\Http\Controllers\UserController@profile')->name('users.profile');
        Route::post('/redeem-coupon', 'App\Http\Controllers\CouponController@redeemCoupon')->name('redeemCoupon');
    Route::post('/do-redeem', 'App\Http\Controllers\CouponController@doRedeemCoupon')->name('doRedeem');

        Route::prefix('admin')->group(function () {
            Route::get('/setlang', 'App\Http\Controllers\AppSettingController@setLanguage');
            Route::get('dashboard', 'App\Http\Controllers\DashboardController@index')->name('dashboard');
            Route::get('/', 'App\Http\Controllers\DashboardController@index')->name('dashboard');

            Route::resource('users', App\Http\Controllers\UserController::class);
            Route::get('change-user-status/{id}', 'App\Http\Controllers\UserController@changeStatus');
            Route::get('createOrder/{id}', 'App\Http\Controllers\UserController@createOrder');
            Route::get('users/wallet/{id}', 'App\Http\Controllers\UserController@userWalletLists');
            Route::post('users/wallet/transaction/{id}', 'App\Http\Controllers\UserController@doSubmituserWallet');



            Route::resource('customer', App\Http\Controllers\CustomerController::class);
            Route::get('change-customer-status/{id}', 'App\Http\Controllers\CustomerController@changeStatus');
            Route::get('customer/wallet/{id}', 'App\Http\Controllers\CustomerController@userWalletLists');
            Route::post('customer/wallet/transaction/{id}', 'App\Http\Controllers\CustomerController@doSubmituserWallet');
            

            Route::resource('drivers', App\Http\Controllers\DriverController::class);
            Route::get('change-driver-status/{id}', 'App\Http\Controllers\DriverController@changeStatus');

            Route::resource('products', App\Http\Controllers\ProductController::class);
            Route::get('change-product-status/{id}', 'App\Http\Controllers\ProductController@changeStatus');
            Route::get('products/translation/{id}', 'App\Http\Controllers\ProductController@translation');
            Route::post('products/translation/{id}', 'App\Http\Controllers\ProductController@updateTranslation');

            Route::resource('banners', App\Http\Controllers\BannerController::class);
            Route::get('change-banner-status/{id}', 'App\Http\Controllers\BannerController@changeStatus');
            Route::get('banners/translation/{id}', 'App\Http\Controllers\BannerController@translation');
            Route::post('banners/translation/{id}', 'App\Http\Controllers\BannerController@updateTranslation');

            Route::resource('orders', App\Http\Controllers\OrderController::class);
            Route::get('cancel-order-request', 'App\Http\Controllers\OrderController@cancelOrderRequest');
            Route::get('declined-order-request/{id}', 'App\Http\Controllers\OrderController@declinedOrderRequest');
            Route::get('approved-order-request/{id}', 'App\Http\Controllers\OrderController@approvedOrderRequest');
            Route::get('revenue', 'App\Http\Controllers\OrderController@revenue');
            Route::get('delivery', 'App\Http\Controllers\OrderController@delivery');
            Route::post('update-delivery-status','App\Http\Controllers\OrderController@updateOrderDeliveryStatus');
            Route::post('assign-driver','App\Http\Controllers\OrderController@assignDriverForDeliver');
            Route::post('bulk-assign-driver','App\Http\Controllers\OrderController@bulkAssignDriverForDeliver');
            Route::get('subscription', 'App\Http\Controllers\OrderController@activeSubscription');
            Route::get('export', 'App\Http\Controllers\OrderController@export');
            Route::get('revenue-report-export', 'App\Http\Controllers\OrderController@exportRevenueReport');
            Route::get('assignDriver/{id}', 'App\Http\Controllers\OrderController@assignDriver');

            Route::resource('coupons', App\Http\Controllers\CouponController::class);
            Route::get('change-coupon-status/{id}', 'App\Http\Controllers\CouponController@changeStatus');
            Route::post('coupons/translation/{id}', 'App\Http\Controllers\CouponController@updateTranslation');
            Route::get('coupons/translation/{id}', 'App\Http\Controllers\CouponController@translation');
            Route::get('coupons/assign/{id}', 'App\Http\Controllers\CouponController@assign');
            Route::post('coupon/assigned/{id}', 'App\Http\Controllers\CouponController@assigned');

            Route::resource('payments', App\Http\Controllers\PaymentController::class);

            Route::resource('site_contents', App\Http\Controllers\SiteContentController::class);
            Route::get('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@translation');
            Route::post('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@updateTranslation');
            
            Route::resource('contact_us', App\Http\Controllers\ContactUsController::class);

            Route::resource('timeslots', App\Http\Controllers\TimeslotController::class);
            Route::get('change-timeslot-status/{id}', 'App\Http\Controllers\TimeslotController@changeStatus');
            Route::get('timeslots/translation/{id}', 'App\Http\Controllers\TimeslotController@translation');
            Route::post('timeslots/translation/{id}', 'App\Http\Controllers\TimeslotController@updateTranslation');

            Route::resource('currencies', App\Http\Controllers\CurrencyController::class);
            Route::get('change-currencies-status/{id}', 'App\Http\Controllers\CurrencyController@changeStatus');

            Route::resource('languages', App\Http\Controllers\LanguagesController::class);
            Route::post('languages/update/{id}', 'App\Http\Controllers\LanguagesController@update');
            Route::get('change-languages-status/{id}', 'App\Http\Controllers\LanguagesController@changeStatus');

            Route::resource('keywords', App\Http\Controllers\LanguagesKeywordsController::class);
            Route::resource('notifications', App\Http\Controllers\PushNotificationController::class);

            Route::resource('about_us', App\Http\Controllers\AboutUsController::class);
            Route::get('about_us/translation/{id}', 'App\Http\Controllers\AboutUsController@translation');
            Route::post('about_us/translation/{id}', 'App\Http\Controllers\AboutUsController@updateTranslation');

            Route::get('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@translation');
            Route::post('site_contents/translation/{id}', 'App\Http\Controllers\SiteContentController@updateTranslation');

            Route::resource('holidays', App\Http\Controllers\NonWorkinDaysController::class);

            Route::resource('delivery_areas', App\Http\Controllers\DeliveryAreasController::class);
            Route::get('change-delivery-area-status/{id}', 'App\Http\Controllers\DeliveryAreasController@changeStatus');
        });

        Route::prefix('admin/settings')->group(function () {
            Route::patch('update', 'App\Http\Controllers\AppSettingController@updateSetting');
            Route::patch('translate', 'App\Http\Controllers\AppSettingController@translate');
            Route::get('sync-translation', 'App\Http\Controllers\AppSettingController@syncTranslation');
            Route::get('/{type?}/{tab?}', [App\Http\Controllers\AppSettingController::class, 'index'])->where('type', '[A-Za-z]*')->where('tab', '[A-Za-z]*')->name('app-settings');
        });
    });

    Auth::routes();
});