
<?php $__env->startSection('sitecontent'); ?>

<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        <?php echo $__env->make('partials.site.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="inner-heading"><?php echo e(__('lang.checkout_title')); ?></div>
</section>

<section class="order-details-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-11">
                <?php echo $__env->make('partials.site.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="chooselocation selectlocation">
                    <span><img src="<?php echo e(asset('site-assets/images/watch-icon.png')); ?>" /></span>
                    <?php echo e(__('lang.checout_time_of_delivery')); ?>

                </div>
                <?php echo Form::model(null, ['method' => 'POST', 'url' => ['do-place-order']]); ?>

                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="delivery_address_id" value="<?php echo e($delivery_address_id); ?>"> 
                    <input type="hidden" name="timeslot_id" id="timeslot_id" value="<?php echo e($response['timeslots'][count($response['timeslots'])-1]->id); ?>"> 
                    <div class="addressformbg checkgrp">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="addressform">
                                    <div class="row justify-content-end">
                                        <div class="form-group col-md-12">
                                            <div class="radio">
                                                <div class="row">
                                                    <?php $__currentLoopData = $response['timeslots']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timeslots): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <input label="<?php echo e($timeslots->name); ?>" type="radio" id="<?php echo e($timeslots->name); ?>" onclick="selectTimeSlot(<?php echo e($timeslots->id); ?>)" value="<?php echo e(date('h:i A',strtotime($timeslots->from_time))); ?>  - <?php echo e(date('h:i A',strtotime($timeslots->to_time))); ?>" name="timeslots" checked/>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="chooselocation mt-4 mb-13 selectlocation">
                        <span><img src="<?php echo e(asset('site-assets/images/payment-icon.png')); ?>" /></span>
                        <?php echo e(__('lang.Payment_method')); ?>

                    </div>

                    <div class="select-address select-address-placeorder paymentmethod">
                        <?php if(setting('enable_cod')=='1'): ?>
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio1" name="payment_method" value="cash" onclick="onLinePayment('no')" />
                            <label class="custom-control-label" for="customRadio1"> <?php echo e(__('lang.pay_using_cash_on_delivery')); ?></label>
                        </div>
                        <?php endif; ?>

                        <?php if(setting('enable_wallet')=='1' && $response['total_wallet']>=$total['final_amount']): ?>
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio2" name="payment_method" value="wallet" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio2"> <?php echo e(__('lang.pay_using_dome_wallet')); ?></label>
                            <a href="<?php echo e(url('/wallet')); ?>" style="font-size: 17px;font-weight: bold;top: 17px;color: #124d71;" target="_blank"><?php echo e(__('lang.my_balance')); ?> | <?php echo e(\Helpers::currency($response['total_wallet'])); ?></a>
                        </div>
                        <?php endif; ?>
                        <?php if(setting('enable_oppwa')=='1'): ?>
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio3" name="payment_method" value="Oppwa" onclick="onLinePayment('no')"/>
                            <label class="custom-control-label" for="customRadio3"> <?php echo e(__('lang.pay_using_credit_card')); ?></label>
                        </div>
                        <?php endif; ?>
                        <?php if(setting('enable_razorpay')=='1'): ?>
                        <div class="custom-control select-address-checkboxes custom-radio">
                            <input type="radio" class="custom-control-input" id="customRadio4" name="payment_method" value="razorpay" onclick="onLinePayment('yes')" checked/>
                            <label class="custom-control-label" for="customRadio4"> <?php echo e(__('lang.pay_using_razorpay')); ?></label>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="cart-total-box">
                        <p><label><?php echo e(__('lang.order_sub_total')); ?></label> <?php echo e(\Helpers::currency($total['subtotal'])); ?></p>
                        <p><label><?php echo e(__('lang.order_vat')); ?> <?php echo e(setting('default_tax')); ?>%</label> <?php echo e(\Helpers::currency($total['tax'])); ?></p>
                        <p><label><?php echo e(__('lang.order_delivery')); ?></label> <?php echo e(($total['delivery_fee']>0)?\Helpers::currency($total['delivery_fee']):__('lang.order_delivery_free')); ?></p>
                        <p class="coupondis"><label><?php echo e(__('lang.order_coupon_discount')); ?></label> <?php if($total['is_coupon_applied']): ?> -<?php echo e(\Helpers::currency($total['promotional_disount'])); ?> <?php else: ?> 0.00 <?php endif; ?> </p>
                        <p class="totalrow"><label><?php echo e(__('lang.order_total')); ?></label>  <?php echo e(\Helpers::currency($total['final_amount'])); ?></p>
                        <p id="offline_payment_div" class="hide">
                            <button class="submit-btn mt-3 full-width-btn" type="submit"><?php echo e(__('lang.place_order_button')); ?> &nbsp;&nbsp;<img src="<?php echo e(asset('site-assets/images/arrowright.png')); ?>" class="mt-n-1" /></button>
                        </p>
                    </div>
                <?php echo Form::close(); ?>

                <div id="online_payment_div" class="cart-total-box" style="clear: both;">
                    <form action="<?php echo e(url('do-place-order')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <script
                            src="https://checkout.razorpay.com/v1/checkout.js"
                            data-key="<?php echo e(setting('razorpay_key')); ?>"
                            data-amount="<?php echo e($total['final_amount']*100); ?>"
                            data-currency="INR"                
                            data-theme.color="#14a1a7",
                            data-button_text = "<?php echo e(__('lang.place_order_button')); ?>"
                            data-button_theme = "submit-btn mt-3"
                        ></script>
                        <input type="hidden" name="delivery_address_id" value="<?php echo e($delivery_address_id); ?>"> 
                        <input type="hidden" name="timeslot_id" id="timeslot_id_2" value="<?php echo e($response['timeslots'][count($response['timeslots'])-1]->id); ?>"> 
                        <input type="hidden" name="payment_method" id="payment_method" value="razorpay"> 
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<footer class="footer">
    <?php echo $__env->make('partials.site.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</footer>

<script type="text/javascript">
    function onLinePayment(val) {
        if(val=='yes'){
            $("#offline_payment_div").addClass("hide");
            $("#online_payment_div").removeClass("hide");
        }
        else{
            $("#online_payment_div").addClass("hide");
            $("#offline_payment_div").removeClass("hide");
        }
    }
</script>
<!-- END: Content-->
<?php $__env->stopSection(); ?>

<style type="text/css">
    .razorpay-payment-button{
        background: #af7ab3;
        color: #fff;
        padding: 0px;
        display: inline-block;
        font-size: 14px;
        font-family: Helvetica-Bold, Helvetica, sans-serif;
        border: none;
        border-radius: 35px;
        height: 60px;
        line-height: 60px;
        padding: 0px 25px;
        width: 100%;
    }
    .razorpay-payment-button:hover {
        background: #06283d;
    }
</style>
<?php echo $__env->make('layouts.site-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/waterfl/public_html/resources/views/place-order.blade.php ENDPATH**/ ?>