<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped"> 
        <div class="col-12"> 
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_menu_orders_list')); ?></h4>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                <th>Name</th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_order_status')); ?></th>
                                <th>Driver Assigned</th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $phone = DB::table('users')->where('id',$res->user_id)->first()->phone;;
                            $name = DB::table('users')->where('id',$res->user_id)->first()->name;;
                            ?>
                            
                            <tr>
                                <?php
                                    if($res->driver_id > 0){
                                     $driver = DB::table('users')->where('id',$res->driver_id)->first()->name;
                                    }
                                    else
                                    {
                                        $driver = '--';
                                    }
                                                                  
                            ?>
                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->id)); ?>"><?php echo e($res->id); ?></a></td>
                                <td><?php echo e($name); ?></td>
                                <td><?php echo e($phone); ?></td>
                                <td><?php echo e(isset($res->order_status) ? $res->order_status : '--'); ?></td>
                                <td><?php echo e($driver); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('orders.show', $res->id)); ?>">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_detail')); ?></span>
                                            </a>
                                            <a class="dropdown-item" href="<?php echo e(URL('admin/assignDriver/'.$res->id )); ?>">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span>assign Driver</span>
                                            </a>
                                           <!--  <a class="dropdown-item" href="<?php echo e(route('orders.edit', $res->id)); ?>">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                            </a> -->
                                            <?php echo Form::open(['route' => ['orders.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="8" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/orders/table.blade.php ENDPATH**/ ?>