<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
       <div class="col-12">
           <div class="card">
               <div class="card-header">
                   <h4 class="card-title">Delivery Areas List</h4>
                   <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
               </div>
               <div class="table-responsive">
                   <table class="table table-striped">
                       <thead>
                           <tr>
                               <th><?php echo e(__('lang.admin_table_sno')); ?></th>
                               <th><?php echo e(__('lang.admin_location_name')); ?></th>
                               <th><?php echo e(__('lang.admin_zip_code')); ?></th>
                               <th><?php echo e(__('lang.admin_status')); ?></th>
                               <th><?php echo e(__('lang.admin_table_action')); ?></th>
                           </tr>
                       </thead>
                       <tbody>
                        <?php $i=0; ?>
                           <?php if(count($data) > 0): ?>
                           <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <?php $i++; ?>
                           <tr>
                               <td><?php echo e($i); ?></td>
                               <td><?php echo e(isset($res->location_name)?$res->location_name:'--'); ?></td>
                               <td><?php echo e(isset($res->zip_code)?$res->zip_code:'--'); ?></td>
                               <td>
                                   <?php if($res->status == 1): ?>
                                       <a href="<?php echo e(url('admin/change-delivery-area-status/'.$res->id)); ?>">
                                           <span class="badge rounded-pill badge-light-primary me-1"><?php echo e(__('lang.admin_active')); ?></span></a>
                                   <?php else: ?>
                                       <a href="<?php echo e(url('admin/change-delivery-area-status/'.$res->id)); ?>">
                                           <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                                   <?php endif; ?>
                               </td>
                               <td>
                                   <div class="dropdown">
                                       <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                           <i data-feather="more-vertical"></i>
                                       </button>
                                       <div class="dropdown-menu">
                                           <a class="dropdown-item" href="<?php echo e(route('delivery_areas.edit', $res->id)); ?>">
                                               <i data-feather="edit-2" class="me-50"></i>
                                               <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                           </a>
                                           <?php echo Form::open(['route' => ['delivery_areas.destroy', $res->id], 'method' => 'delete']); ?>

                                           <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                               'data-toggle' => 'tooltip',
                                               'data-placement' => 'bottom',
                                               'title' => 'Delete',
                                               'type' => 'submit',
                                               'class' => 'dropdown-item',
                                               'onclick' => "return confirm('Are you sure?')",
                                               'style' => "width:100%;"
                                           ]); ?>

                                           <?php echo Form::close(); ?>

                                       </div>
                                   </div>
                               </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           <?php else: ?>
                           <tr>
                               <td colspan="8" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                           </tr>
                           <?php endif; ?>
                       </tbody>
                   </table>
               </div>
               <div class="card-footer">
                   <div class="pagination" style="float: right;">
                       <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                   </div>
               </div>
           </div>
       </div>
   </div>
   <!-- Striped rows end -->
</div>
<?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/delivery_areas/table.blade.php ENDPATH**/ ?>