<?php $__env->startSection('sitecontent'); ?>
<section class="headerbg headerbg-inner">
    <div class="header header-padding">
        <?php echo $__env->make('partials.site.header-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="inner-heading"><?php echo e(__('lang.contact_title')); ?></div>
</section>
<section class="contact-bg">
    <div class="container">
        <div class="contact-top">
            <div class="row">
                <div class="col-md-6">
                    <div class="loginform contactform">
                        <?php if(Session::has('message')): ?>
                        <div class="alert alert-success" role="alert">
                          <?php echo e(Session::get('message')); ?>

                        </div>
                        <?php endif; ?>
                        <?php echo Form::model(null, ['method' => 'POST', 'url' => ['contact-us']]); ?>

                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <span><img src="<?php echo e(asset('site-assets/images/user_wall.svg')); ?>"/></span>
                                    <input type="text" class="form-control" name="name" placeholder="<?php echo e(__('lang.placeholder_your_name')); ?> *" required />
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="<?php echo e(asset('site-assets/images/mail.svg')); ?>"/></span>
                                    <input type="email" class="form-control" name="email" placeholder="<?php echo e(__('lang.placeholder_email_address')); ?> *" required/>
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="<?php echo e(asset('site-assets/images/mobile0edit.svg')); ?>"/></span>
                                    <input type="text" onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" class="form-control" name="mobile" maxlength="10"  placeholder="<?php echo e(__('lang.placeholder_mobile_num')); ?> *" required/>
                                </div>
                                <div class="form-group col-md-12">
                                    <span><img src="<?php echo e(asset('site-assets/images/pay_new.svg')); ?>"/></span>
                                    <textarea class="form-control" name="message" id="message" placeholder="<?php echo e(__('lang.placeholder_note')); ?> *" style="height: 115px; padding-top: 20px;" required></textarea>
                                </div>
                                <div class="form-group col-md-5">
                                    <button class="submit-btn text-uppercase mt-4"><img src="<?php echo e(asset('site-assets/images/arrowright.png')); ?>"/> <?php echo e(__('lang.send_button')); ?></button>
                                </div>
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="getintouch-bg">
                        <h4><?php echo e(__('lang.contact_des_key')); ?></h4>
                        <h6><?php echo e(__('lang.contact_description')); ?></h6>
                        <ul>
                            <li>
                                <img src="<?php echo e(asset('site-assets/images/mail.svg')); ?>"  />
                                <h4><?php echo e(setting('contact_email')); ?></h4>
                                <p><?php echo e(__('lang.email')); ?></p>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('site-assets/images/mobile0edit.svg')); ?>"  />
                                <h4><?php echo e(setting('contact_phone')); ?></h4>
                                <p><?php echo e(__('lang.phone')); ?></p>
                            </li>
                            <li>
                                <img src="<?php echo e(asset('site-assets/images/map.svg')); ?>"  />
                                <h4><?php echo e(setting('contact_address')); ?></h4>
                                <p><?php echo e(__('lang.address')); ?></p>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="contactmap">
    <iframe
        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3621.144262915997!2d46.61276631447684!3d24.824739652803153!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2f1b5ab2e599c1%3A0x58ab1ee4e94e9c89!2sKing%20Fahd%20Rd%2C%20Riyadh%2011564%2C%20Saudi%20Arabia!5e0!3m2!1sen!2sin!4v1623818915876!5m2!1sen!2sin"
        width="100%"
        height="500"
        style="border: 0;"
        allowfullscreen=""
        loading="lazy"
    ></iframe>
</div>
<footer class="footer">
    <?php echo $__env->make('partials.site.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</footer>
<!-- END: Content-->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.site-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/waterfl/public_html/resources/views/contact.blade.php ENDPATH**/ ?>