<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_order_delivery_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_product_name')); ?></th>
                                <th><?php echo e(__('lang.admin_order_quantity')); ?></th>
                                <th><?php echo e(__('lang.admin_total_amnt')); ?></th>
                                <th><?php echo e(__('lang.admin_delivery_status')); ?></th>
                                <th><?php echo e(__('lang.admin_order_delivery_date')); ?></th>
                                <th><?php echo e(__('lang.admin_order_date')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->order_id)); ?>" target="_blank">#<?php echo e($res->order_id); ?></a></td>
                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                <td><a title="Product Detail" href="<?php echo e(route('products.edit', $res->product_id)); ?>" target="_blank"><?php echo e(($res->product_orders)?($res->product_orders->product)?$res->product_orders->product->name:'--':'--'); ?></a></td>
                                <td><?php echo e(isset($res->product_orders) ? $res->product_orders->quantity : '--'); ?></td>
                                <td><?php echo e(isset($res->product_orders) ? \Helpers::currency($res->product_orders->total_delivery_amount) : '--'); ?></td>
                                <td><?php echo e(isset($res->delivery_status) ? $res->delivery_status->status : '--'); ?></td>
                                <td><?php echo e(isset($res->delivery_date) ? \Helpers::commonDateFormate($res->delivery_date) : '--'); ?></td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                <td><div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('orders.show', $res->id)); ?>">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_detail')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="9" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/orders/revenue_table.blade.php ENDPATH**/ ?>