
<?php $__env->startSection('content'); ?>
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-header row">
            <div class="content-header-left col-md-9 col-12 mb-2">
                <div class="row breadcrumbs-top">
                    <div class="col-12">
                        <h2 class="content-header-title float-start mb-0"><?php echo e(__('lang.admin_menu_users')); ?></h2>
                        <div class="breadcrumb-wrapper">
                            <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo route('dashboard'); ?>"><?php echo e(__('lang.admin_menu_dashboard')); ?></a>
                                </li>
                                <li class="breadcrumb-item <?php echo e(Request::is('admin/users*') ? 'active' : ''); ?>"><a href="<?php echo route('users.index'); ?>"><?php echo e(__('lang.admin_user_list')); ?></a>
                                </li>
                                <li class="breadcrumb-item active"><?php echo e(__('lang.admin_user_info')); ?>

                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="app-user-edit">
                <div class="card">
                    <div class="card-body">
                        <div class="tab-content">
                            <div class="tab-pane active" id="account" aria-labelledby="account-tab" role="tabpanel">
                                <?php echo Form::model($user, ['method' => 'PATCH','enctype'=>'multipart/form-data', 'route' => ['users.update', $user->id]]); ?>

                                <?php echo csrf_field(); ?>
                                <div class="d-flex mb-2">
                                    <?php if($user->image): ?>
                                    <img src="<?php echo e(asset('app-assets/images/users/'.$user->image)); ?>" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" onerror="this.src='<?php echo e(asset('app-assets/images/no-image.png')); ?>';"/>
                                    <?php else: ?>
                                    <img src="<?php echo e(asset('app-assets/images/no-image.png')); ?>" alt="users avatar" class="user-avatar users-avatar-shadow rounded me-2 my-25 cursor-pointer" height="90" width="90" />
                                    <?php endif; ?>
                                    <div class="mt-50">
                                    <h4><?php echo e($user->name); ?></h4>
                                        <div class="col-12 d-flex mt-1 px-0">
                                            <label class="btn btn-primary me-75 mb-0" for="change-picture">
                                                <span class="d-none d-sm-block"><?php echo e(__('lang.admin_button_upload')); ?></span>
                                                <input class="form-control" type="file" id="change-picture" hidden accept="image/png, image/jpeg, image/jpg" name="image"/>
                                                <span class="d-block d-sm-none">
                                                    <i class="me-0" data-feather="edit"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="username"><?php echo e(__('lang.admin_user_name')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(__('lang.admin_user_name')); ?>" value="<?php echo e($user->name); ?>" name="name" id="username" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="email"><?php echo e(__('lang.admin_email')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(__('lang.admin_email')); ?>" value="<?php echo e($user->email); ?>" name="email" id="email" />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="phone"><?php echo e(__('lang.admin_user_phone')); ?></label>
                                            <input type="text" class="form-control" placeholder="<?php echo e(__('lang.admin_user_phone')); ?>" value="<?php echo e($user->phone); ?>" name="phone" id="phone" />
                                        </div>
                                    </div>
                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Choose Emirates</label>
                    <?php
                    $emirates = DB::table('emirates')->get();
                    $a = 0;

                    $em_id =$user->emirates;
                    if($em_id != null)
                    {
                        $em  = DB::table('emirates')->where('id',$em_id)->first()->name;
                        $ar = DB::table('areas')->where('emirates_id',$em_id)->where('id',$user->area)->first()->name;
                        $a = 1;
                    }
                    
                    ?>
                    <select class="form-select" name="emirates" id="emirates">
                        <?php 
                        if($a ==0)
                        {
                        ?>
                        <option>Please Select</option>
                        <?php 
                        }
                        else
                        {
                        ?>
                        <option value="<?php echo e($em_id); ?>"><?php echo e($em); ?></option>
                        <?php
                        }
                        ?>
                        <?php $__currentLoopData = $emirates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $em): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($em->id); ?>"><?php echo e($em->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                </div>

                <div class="col-md-4">

                 <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Choose Area</label>
                    
                    <select class="form-select" name="area" id="area">
                        <?php 
                        if($a ==0)
                        {
                        ?>
                        <option>Please Select</option>
                        <?php 
                        }
                        else
                        {
                        ?>
                        <option value="<?php echo e($user->area); ?>"><?php echo e($ar); ?></option>
                        <?php
                        }
                        ?>
                    </select>
                </div>
                </div>

                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Building Name/Number</label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="Building Name" aria-label="john.doe@example.com" name="building" value="<?php echo e($user->building); ?>" />
                    
                </div>
                </div>
                <div class="col-md-4">
                <div class="mb-1">
                    <label class="form-label" for="basic-icon-default-email">Flat Number</label>
                    <input type="text" id="basic-icon-default-email" class="form-control dt-email" placeholder="Flat Number" aria-label="john.doe@example.com" name="flat_no" value="<?php echo e($user->flat_no); ?>" />
                    
                </div>
                </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="password"><?php echo e(__('lang.admin_password')); ?></label>
                                            <input type="password" class="form-control" placeholder="<?php echo e(__('lang.admin_password')); ?>" name="password" id="password"  />
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-1">
                                            <label class="form-label" for="status"><?php echo e(__('lang.admin_status')); ?></label>
                                            <select class="form-select" id="status" name="status">
                                                <option value="1" <?php if($user->status == 1): ?> selected  <?php endif; ?>><?php echo e(__('lang.admin_active')); ?></option>
                                                <option value="0" <?php if($user->status == 0): ?> selected  <?php endif; ?>><?php echo e(__('lang.admin_deactive')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 d-flex flex-sm-row flex-column mt-2">
                                        <button type="submit" class="btn btn-primary mb-1 mb-sm-0 me-0 me-sm-1"><?php echo e(__('lang.admin_button_save_changes')); ?></button>
                                        <a href="<?php echo route('users.index'); ?>" class="btn btn-outline-secondary"><?php echo e(__('lang.admin_button_back')); ?></a>
                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script type='text/javascript'>

    $(document).ready(function(){



      $('#emirates').change(function(){

         // Department id
         var id = $(this).val();
         var currentUrl = window.location.href;
         var segments = currentUrl.split('/');
         var newSegments = segments.slice(0, -4);
         var newUrl = newSegments.join('/');

         // Empty the dropdown
         $('#area').find('option').not(':first').remove();

         // AJAX request
         $.ajax({
           url: newUrl+'/getArea/'+id,
           type: 'get',
           dataType: 'json',
           success: function(response){

             var len = 0;
             if(response['data'] != null){
               len = response['data'].length;
             }

             if(len > 0){
               // Read data and create <option >
               for(var i=0; i<len; i++){

                 var id = response['data'][i].id;
                 var name = response['data'][i].name;

                 var option = "<option value='"+id+"'>"+name+"</option>";

                 $("#area").append(option);
               }


             }

           }
        });
      });




    });

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/users/edit.blade.php ENDPATH**/ ?>