<!DOCTYPE html>
<html class="loading hide bordered-layout" lang="en" data-layout="bordered-layout" data-textdirection="ltr"><!-- dark-layout -->
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="description" content="Mobile APP">
    <meta name="keywords" content="Mobile APP">
    <meta name="author" content="Team June">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(setting('site_title')); ?></title>
    <link rel="apple-touch-icon" href="<?php echo e(asset('app-assets/images/ico/apple-icon-120.png')); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('app-assets/images/ico/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('app-assets/images/ico/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('app-assets/images/ico/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('app-assets/images/ico/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('app-assets/images/ico/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('app-assets/images/ico/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('app-assets/images/ico/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('app-assets/images/ico/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('app-assets/images/ico/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('app-assets/images/ico/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('app-assets/images/ico/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('app-assets/images/ico/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('app-assets/images/ico/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('app-assets/images/ico/manifest.json')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('app-assets/images/ico/ms-icon-144x144.png')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/vendors.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/extensions/toastr.min.css')); ?>">
    <!-- Datatable css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap5.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/rowGroup.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css')); ?>">
    <?php
        $direct = "";
        if (Session()->get('admin_direction') != '') {
            if (Session()->get('admin_direction') == 'rtl') {
                $direct = "-rtl";
            }
        }
    ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/bootstrap.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/bootstrap-extended.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/colors.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/components.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/themes/dark-layout.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/themes/bordered-layout.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/themes/semi-dark-layout.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/core/menu/menu-types/vertical-menu.css')); ?>">
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDk77EgsWrBF3epQ3fXzPl-lK7uJVpOgn0&libraries=places"></script>
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/plugins/extensions/ext-component-toastr.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/css' . $direct . '/plugins/forms/pickers/form-flat-pickr.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/style' . $direct . '.css')); ?>">
    <script>
        var base_url = '<?php echo e(url("")); ?>';
    </script>
    <style type="text/css">
        .pac-container{
                z-index: 10010;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern  navbar-floating footer-static  " data-open="click" data-menu="vertical-menu-modern" data-col="">
    <nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow container-xxl">
        <div class="navbar-container d-flex content">
            <div class="bookmark-wrapper d-flex align-items-center">
                <ul class="nav navbar-nav d-xl-none">
                    <li class="nav-item"><a class="nav-link menu-toggle" href="#"><i class="ficon" data-feather="menu"></i></a></li>
                </ul>
            </div>
            <ul class="nav navbar-nav align-items-center ms-auto">
                <li class="nav-item dropdown dropdown-language">
                    <?php
                    $langList = \Helpers::getAllLangList();

                    if (Session()->has('admin_locale') AND array_key_exists(Session()->get('admin_locale'), config('languages'))) {
                        $langCode = Session()->get('admin_locale');
                    }
                    else { // This is optional as Laravel will automatically set the fallback language if there is none specified
                        $langCode = config('app.fallback_locale');
                    }
                    ?>
                    <a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="flag-icon flag-icon-<?php echo e(($langCode=='en')?'us':$langCode); ?>"></i><span class="selected-language"><?php echo e(config('languages')[$langCode]); ?></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">                        
                        <?php if(count($langList)>0): ?>
                            <?php $__currentLoopData = $langList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langRow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="dropdown-item" href="<?php echo url('/admin/setlang'); ?>?lang=<?php echo e($langRow->language_code); ?>" data-language="<?php echo e($langRow->language_code); ?>"><i class="flag-icon flag-icon-<?php echo e(($langRow->language_code=='en')?'us':$langRow->language_code); ?>"></i> <?php echo e($langRow->language_name); ?></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </li>
                <li class="nav-item d-none d-lg-block">
                    <a class="nav-link nav-link-style">
                        <i class="ficon" data-feather="sun" id="dark"></i>
                        <i class="ficon" data-feather="moon" id="light"></i>
                    </a>
                </li>
                <li class="nav-item dropdown dropdown-user">
                    <?php if(auth()->guard()->check()): ?>
                    <a class="nav-link dropdown-toggle dropdown-user-link" id="dropdown-user" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="user-nav d-sm-flex d-none"><span class="user-name fw-bolder"><?php echo auth()->user()->name; ?></span><span class="user-status"><?php echo e(__('lang.admin_admin')); ?></span></div><span class="avatar">
                            <?php if(auth()->user()->image): ?>
                            <img class="round" src="<?php echo e(asset('app-assets/images/users/'.auth()->user()->image)); ?>" alt="avatar" height="40" width="40"><span class="avatar-status-online">
                            <?php else: ?> 
                            <img class="round" src="<?php echo e(asset('app-assets/images/avatars/2.png')); ?>" alt="avatar" height="40" width="40"><span class="avatar-status-online">
                            <?php endif; ?>
                                </span></span>
                    </a>
                    <?php endif; ?>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
                        <a class="dropdown-item" href="<?php echo route('users.profile'); ?>">
                            <i class="me-50" data-feather="user"></i> <?php echo e(__('lang.admin_profile')); ?>

                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="<?php echo url('/logout'); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><i class="me-50" data-feather="power"></i> <?php echo e(__('lang.admin_logout')); ?></a>
                        <form id="logout-form" action="<?php echo e(url('/logout')); ?>" method="POST" class="form-horizontal" style="display: none;"><?php echo e(csrf_field()); ?></form>
                    </div>
                </li>
            </ul>
        </div>
    </nav>
    
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="<?php echo route('dashboard'); ?>">
                        <h2>
                            <img src="<?php echo e(asset('app-assets/images/logo.png')); ?>" style="width: 60px;">
                        </h2>
                    </a>
                </li>
                <li class="nav-item nav-toggle"><a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse"><i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i><i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary" data-feather="disc" data-ticon="disc"></i></a></li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <div class="main-menu-content">
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <?php echo $__env->make('layouts.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </ul>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <?php echo $__env->yieldContent('content'); ?>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix mb-0"><span class="float-md-start d-block d-md-inline-block mt-25"><?php echo e(__('lang.admin_footer_copyright')); ?> &copy; <?php echo date("Y");?>, <?php echo e(__('lang.admin_footer_text')); ?></span></span></p>
    </footer>
    <button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>
    <!-- END: Footer-->
    <?php if(Session::has('message')): ?>
    <script>
        setTimeout(function () {
            toastr['success']('You have successfully logged in. Now you can start to explore!','👋 Welcome Admin!',{
                closeButton: true,
                tapToDismiss: false,
                rtl: isRtl
            });
        }, 2000);
    </script>
    <?php endif; ?>

    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/vendors.min.js')); ?>"></script>
    <!-- BEGIN Vendor JS-->

    
    <script src="<?php echo e(asset('app-assets/vendors/js/extensions/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>

    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="<?php echo e(asset('app-assets/js/core/app-menu.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/js/core/app.js')); ?>"></script>
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/js/scripts/pages/app-user-edit.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/js/scripts/forms/pickers/form-pickers.js')); ?>"></script>
    <!-- END: Page JS-->

    <script>
        $(window).on('load', function() {
            function disablePrev() { window.history.forward() }
            disablePrev();
            window.onpageshow = function(evt) { if (evt.persisted) disableBack() }
            $("html").removeClass('hide');
            if(localStorage.getItem("bordered-layout-current-skin")=='dark-layout'){
                $("html").addClass("dark-layout");
                $("html").removeClass("bordered-layout");
                $("#light").remove();
            }else{
                $("html").addClass("bordered-layout");
                $("html").removeClass("dark-layout");
                $("#dark").remove();
            }
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
            <?php if(Session::has('error')): ?>
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>

            <?php if(Session::has('info')): ?>
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.info("<?php echo e(session('info')); ?>");
            <?php endif; ?>

            <?php if(Session::has('warning')): ?>
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.warning("<?php echo e(session('warning')); ?>");
            <?php endif; ?>

            <?php if(Session::has('success')): ?>
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
        })
    </script>

    <?php if (Request::is('admin/settings/app/websetting*')){ ?>

        <script type="text/javascript">
            $('#website_logo').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.website_logo').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#about_product').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('#about_product_src').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#mobile_image').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('#mobile_image_img').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });


            $('#icon_1').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_1').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_2').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_2').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_3').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_3').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });

            $('#icon_4').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.icon_4').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });
            $('#website_bg_image').on('change', function (e) {
                var reader = new FileReader(),
                files = e.target.files;
                reader.onload = function () {
                    $('.website_bg_image').attr('src', reader.result);
                };
                reader.readAsDataURL(files[0]);
            });
    </script>
    <?php } ?>

    <!-- BEGIN: Content-->
    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script type="text/javascript">
                toastr.options =
                {
                    "closeButton" : true,
                    "progressBar" : true
                }
                toastr.error("<?php echo e($error); ?>");
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    
</body>
</html><?php /**PATH /home/waterfl/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>