<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_product_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($products->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($products->firstItem()); ?>-<?php echo e($products->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($products->total()); ?> <?php }?></h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('lang.admin_image')); ?></th>
                                    <th><?php echo e(__('lang.admin_name')); ?></th>
                                    <th><?php echo e(__('lang.admin_price')); ?></th>
                                    <th><?php echo e(__('lang.admin_discount_price')); ?></th>
                                    <th><?php echo e(__('lang.admin_min_purchase_qty')); ?></th>
                                    <th><?php echo e(__('lang.admin_status')); ?></th>
                                    <th><?php echo e(__('lang.admin_created_at')); ?></th>
                                    <th><?php echo e(__('lang.admin_table_action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($products) > 0): ?>
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td aria-colindex="2" role="cell" class="">
                                        <span class="b-avatar mr-1 badge-secondary rounded-circle">
                                            <span class="b-avatar-img">
                                                <?php if($res->image!=''): ?>
                                                    <img src="<?php echo e(asset('/app-assets/images/products/'.$res->image)); ?>" width="100px" onerror="this.src='<?php echo e(asset('app-assets/images/no-image.png')); ?>';">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('/app-assets/images/no-image.png')); ?>">
                                                <?php endif; ?>
                                            </span>
                                        </span>
                                    </td>
                                    <td><?php echo e(isset($res->name)?$res->name:'--'); ?></td>
                                    <td><?php echo e(isset($res->price)?\Helpers::currency($res->price):'--'); ?></td>
                                    <td><?php echo e(isset($res->discount_price)?\Helpers::currency($res->discount_price):'--'); ?></td>
                                    <td><?php echo e(isset($res->minimum_order_quantity)?$res->minimum_order_quantity:'--'); ?></td>
                                    <td>
                                        <?php if($res->status == 1): ?>
                                            <a href="<?php echo e(url('admin/change-product-status/'.$res->id)); ?>">
                                            <span class="badge rounded-pill badge-light-primary me-1"><?php echo e(__('lang.admin_active')); ?></span></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(url('admin/change-product-status/'.$res->id)); ?>">
                                                <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                <i data-feather="more-vertical"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="<?php echo e(route('products.edit', $res->id)); ?>">
                                                    <i data-feather="edit-2" class="me-50"></i>
                                                    <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                                </a>
                                                <a class="dropdown-item" href="<?php echo e(url('admin/products/translation/'.$res->id)); ?>">
                                                    <i data-feather="type" class="me-50"></i>
                                                    <span><?php echo e(__('lang.admin_button_translation')); ?></span>
                                                </a>
                                                <?php echo Form::open(['route' => ['products.destroy', $res->id], 'method' => 'delete']); ?>

                                                <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                    'data-toggle' => 'tooltip',
                                                    'data-placement' => 'bottom',
                                                    'title' => 'Delete',
                                                    'type' => 'submit',
                                                    'class' => 'dropdown-item',
                                                    'onclick' => "return confirm('Are you sure?')",
                                                    'style' => "width:100%;"
                                                ]); ?>

                                                <?php echo Form::close(); ?>

                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="9" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($products->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/products/table.blade.php ENDPATH**/ ?>