<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_day_delivery_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>
                                    <div class="checkbox  checkbox-primary" style="    margin-bottom: 0px;">
                                        <input id="checkbox2" type="checkbox" name="check_all" onchange="checkAll(this)" class="check_all" >
                                        <label for="checkbox2"></label>
                                    </div>
                                </th>
                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_product_name')); ?></th>
                                <th><?php echo e(__('lang.admin_order_quantity')); ?></th>
                                <th><?php echo e(__('lang.admin_total_amnt')); ?></th>
                                <th>Driver Status</th>
                                <th><?php echo e(__('lang.admin_delivery_status')); ?></th>
                                <th><?php echo e(__('lang.admin_order_delivery_date')); ?></th>
                                <th><?php echo e(__('lang.admin_order_date')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="checkbox  checkbox-primary">
                                        <input id="checkbox1" class="cb" type="checkbox" name="order_id[]" value="<?php echo e($res->id); ?>">
                                        <label for="checkbox1"></label>
                                    </div>
                                </td>
                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->order_id)); ?>" target="_blank">#<?php echo e($res->order_id); ?></a></td>
                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                <td><a title="Product Detail" href="<?php echo e(route('products.edit', $res->product_id)); ?>" target="_blank"><?php echo e(($res->product_orders)?($res->product_orders->product)?$res->product_orders->product->name:'--':'--'); ?></a></td>
                                <td><?php echo e(isset($res->product_orders) ? $res->product_orders->quantity : '--'); ?></td>
                                <td><?php echo e(isset($res->product_orders) ? \Helpers::currency($res->product_orders->total_delivery_amount) : '--'); ?></td>
                                <td>                                   
                                    <select class="form-select" id="driver_<?php echo e($res->id); ?>" name="driver_<?php echo e($res->id); ?>" title="Order Status" onchange="doAssignDrivers('<?php echo e($res->id); ?>',this.value)">
                                        <option value="">Select Driver</option>
                                        <?php $__currentLoopData = $filter['drivers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($row->id); ?>" <?php if($row->id==$res->driver_id): ?> selected <?php endif; ?>><?php echo e($row->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                                <td>
                                    <?php if($res->order_status_id==6): ?>
                                        <?php echo e(isset($res->delivery_status) ? $res->delivery_status->status : '--'); ?>

                                    <?php else: ?>
                                        <select class="form-select" id="order_status_<?php echo e($res->id); ?>" name="order_status_<?php echo e($res->id); ?>" title="Order Status" onchange="doUpdateProductOrderStatus('<?php echo e($res->id); ?>',this.value)">
                                        <?php $__currentLoopData = $filter['order_status']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($row->id); ?>" <?php if($row->id==$res->order_status_id): ?> selected <?php endif; ?>><?php echo e($row->status); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(isset($res->delivery_date) ? \Helpers::commonDateFormate($res->delivery_date) : '--'); ?></td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('orders.show', $res->order_id)); ?>" target="_blank">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_detail')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="9" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div style="float:left;">
                        <select style="width: 300px;" class="form-select" id="drivers" name="drivers" title="Order Status" onchange="doBulkAssignDrivers(this.value)">
                            <option value="">Select Driver</option>
                            <?php $__currentLoopData = $filter['drivers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($row->id); ?>" <?php if($row->id==$res->driver_id): ?> selected <?php endif; ?>><?php echo e($row->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div>

<script type="text/javascript">
     function checkAll(that) {
        $('.cb').prop("checked", that.checked);
     }
    function doUpdateProductOrderStatus(id,val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : id,
            'order_status_id' : val
        };
        $.ajax({
            type: 'post',
            url: base_url + '/admin/update-delivery-status',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }

    function doAssignDrivers(id,val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : id,
            'driver_id' : val
        };
        $.ajax({
            type: 'post',
            url: base_url + '/admin/assign-driver',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }

    function doBulkAssignDrivers(val) {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        var data = {
            'order_item_id' : [],
            'driver_id' : val
        };
        var cboxes = document.getElementsByName('order_id[]');
        var len = cboxes.length;
        for (var i=0; i<len; i++) {
            if(cboxes[i].checked){
                data.order_item_id.push(cboxes[i].value)
            }
        }
        data.order_item_id = data.order_item_id.toString();
        $.ajax({
            type: 'post',
            url: base_url + '/admin/bulk-assign-driver',
            data: data,
            success: function(response) {
                if (response.success) {
                    toastr.options =
                    {
                        "closeButton" : true,
                        "progressBar" : true
                    }
                    toastr.success(response.message);
                    if(val==6){
                        window.location.reload();
                    }
                }
            }
        });
    }
</script><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/orders/delivery_table.blade.php ENDPATH**/ ?>