<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_menu_orders_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_order_status')); ?></th>
                                <th><?php echo e(__('lang.admin_amount')); ?></th>
                                <!-- <th>Coupon</th> -->
                                <th><?php echo e(__('lang.admin_method')); ?></th>
                                <th><?php echo e(__('lang.admin_payment_status')); ?></th>
                                <th><?php echo e(__('lang.admin_date')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->id)); ?>">#<?php echo e($res->id); ?></a></td>
                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                <td><?php echo e(isset($res->order_status) ? $res->order_status->status : '--'); ?></td>
                                <td><?php echo e(isset($res->final_amount) ? \Helpers::currency($res->final_amount) : '--'); ?></td>
                                <td style="text-transform: capitalize;"><?php echo e(isset($res->payment_method) ? $res->payment_method : '--'); ?></td>
                                <td>
                                    <?php if(isset($res->payment_method)): ?>
                                        <?php if($res->payment_method=='cash'): ?>
                                            <?php if(isset($res->payment)): ?>
                                                <?php echo \Helpers::showPaymentStatus($res->payment->status) ?>
                                            <?php else: ?>
                                            --
                                            <?php endif; ?>
                                        <?php else: ?>
                                        <?php echo \Helpers::showPaymentStatus('Paid') ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        --
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('orders.show', $res->id)); ?>">
                                                <i data-feather="eye" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_detail')); ?></span>
                                            </a>
                                            <a class="dropdown-item" href="<?php echo e(route('orders.edit', $res->id)); ?>">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                            </a>
                                            <?php echo Form::open(['route' => ['orders.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="8" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /home/waterfl/public_html/resources/views/orders/table.blade.php ENDPATH**/ ?>