<!-- Basic table -->
<section id="responsive-datatable">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title"><?php echo e(__('lang.admin_cms_page')); ?></h4>
                </div>
                <div class="card-datatable">
                    <table class="dt-responsive table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_page_name')); ?></th>
                                <th><?php echo e(__('lang.admin_title')); ?></th>
                                <th><?php echo e(__('lang.admin_description')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a href="<?php echo e(route('site_contents.edit', $res->id)); ?>"><?php echo e(ucwords($res->page_name)); ?></a></td>
                                <td><?php echo e($res->page_title); ?></td>
                                <td><?php echo substr(strip_tags($res->description),0,300); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('site_contents.edit', $res->id)); ?>">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                            </a>
                                            <a class="dropdown-item" href="<?php echo e(url('admin/site_contents/translation/'.$res->id)); ?>">
                                                <i data-feather="type" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_translation')); ?></span>
                                            </a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="3" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/site_contents/table.blade.php ENDPATH**/ ?>