<!-- Basic table -->
<section id="responsive-datatable">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title"><?php echo e(__('lang.admin_about_us_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="card-datatable">
                    <table class="dt-responsive table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_image')); ?></th>
                                <th><?php echo e(__('lang.admin_type')); ?></th>
                                <th><?php echo e(__('lang.admin_name')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td aria-colindex="2" role="cell" class=""><span
                                        class="b-avatar mr-1 badge-secondary rounded-circle"><span class="b-avatar-img">
                                            <?php if($res->image!=''): ?>
                                            <img src="<?php echo e(asset('/app-assets/images/partners/'.$res->image)); ?>"
                                                width="100px"
                                                onerror="this.src='<?php echo e(asset('app-assets/images/no-image.png')); ?>';">
                                            <?php else: ?>
                                            <img src="<?php echo e(asset('/app-assets/images/no-image.png')); ?>">
                                            <?php endif; ?>
                                        </span></span></td>
                                <td style="text-transform: capitalize"><?php echo e(isset($res->type)?$res->type:'--'); ?></td>
                                <td><?php echo e(isset($res->name)?$res->name:'--'); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('about_us.edit', $res->id)); ?>">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                            </a>
                                            <a class="dropdown-item" href="<?php echo e(url('admin/about_us/translation/'.$res->id)); ?>">
                                                <i data-feather="type" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_translation')); ?></span>
                                            </a>
                                            <?php echo Form::open(['route' => ['about_us.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                            'data-toggle' => 'tooltip',
                                            'data-placement' => 'bottom',
                                            'title' => 'Delete',
                                            'type' => 'submit',
                                            'class' => 'dropdown-item',
                                            'onclick' => "return confirm('Are you sure?')",
                                            'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="4" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/about_us/table.blade.php ENDPATH**/ ?>