<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_timeslot_list')); ?></h4>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_name')); ?></th>
                                <th><?php echo e(__('lang.admin_timeslot_from_time')); ?></th>
                                <th><?php echo e(__('lang.admin_timeslot_to_time')); ?></th>
                                <th><?php echo e(__('lang.admin_status')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(isset($res->name)?$res->name:'--'); ?></td>
                                <td><?php echo e(isset($res->from_time)?date('h:i A',strtotime($res->from_time)):'--'); ?></td>
                                <td><?php echo e(isset($res->to_time)?date('h:i A',strtotime($res->to_time)):'--'); ?></td>
                                <td>
                                    <?php if($res->status == 1): ?>
                                        <a href="<?php echo e(url('admin/change-timeslot-status/'.$res->id)); ?>">
                                            <span class="badge rounded-pill badge-light-primary me-1"><?php echo e(__('lang.admin_active')); ?></span></a>
                                    <?php else: ?>
                                        <a href="<?php echo e(url('admin/change-timeslot-status/'.$res->id)); ?>">
                                            <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="<?php echo e(route('timeslots.edit', $res->id)); ?>">
                                                <i data-feather="edit-2" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_edit')); ?></span>
                                            </a>
                                            <a class="dropdown-item" href="<?php echo e(url('admin/timeslots/translation/'.$res->id)); ?>">
                                                <i data-feather="type" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_button_translation')); ?></span>
                                            </a>
                                            <?php echo Form::open(['route' => ['timeslots.destroy', $res->id], 'method' => 'delete']); ?>

                                            <?php echo Form::button('<i data-feather="trash" class="me-50"></i><span>Delete</span>', [
                                                'data-toggle' => 'tooltip',
                                                'data-placement' => 'bottom',
                                                'title' => 'Delete',
                                                'type' => 'submit',
                                                'class' => 'dropdown-item',
                                                'onclick' => "return confirm('Are you sure?')",
                                                'style' => "width:100%;"
                                            ]); ?>

                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="8" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/timeslots/table.blade.php ENDPATH**/ ?>