<div class="content-body">
    <!-- Striped rows start -->
    <div class="row" id="table-striped">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(__('lang.admin_menu_orders_list')); ?></h4>
                    <h6 style="float: right;"> <?php if ($data->firstItem() != null) {?> <?php echo e(__('lang.admin_showing')); ?> <?php echo e($data->firstItem()); ?>-<?php echo e($data->lastItem()); ?> <?php echo e(__('lang.admin_of')); ?> <?php echo e($data->total()); ?> <?php }?></h6>
                </div>
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th><?php echo e(__('lang.admin_order_id')); ?></th>
                                <th><?php echo e(__('lang.admin_user_phone')); ?></th>
                                <th><?php echo e(__('lang.admin_request_status')); ?></th>
                                <th><?php echo e(__('lang.admin_refund_amnt')); ?></th>
                                <th><?php echo e(__('lang.admin_refund_status')); ?></th>
                                <th><?php echo e(__('lang.admin_payment_status')); ?></th>
                                <th><?php echo e(__('lang.admin_request_date')); ?></th>
                                <th><?php echo e(__('lang.admin_table_action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($data) > 0): ?>
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php if($res->order): ?>
                            <tr>
                                <td><a title="Order Detail" href="<?php echo e(route('orders.show', $res->order_id)); ?>" target="_blank">#<?php echo e($res->order_id); ?></a></td>
                                <td><?php echo e(isset($res->user)?$res->user->phone:'--'); ?></td>
                                <td>
                                    <?php if($res->status == 1): ?>
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-success me-1"><?php echo e(__('lang.admin_approved')); ?></span>
                                        </a>
                                    <?php elseif($res->status == 2): ?>
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-danger me-1"><?php echo e(__('lang.admin_declined')); ?></span>
                                        </a>
                                    <?php else: ?>
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_pending')); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(isset($res->refund_amount) ? \Helpers::currency($res->refund_amount) : '--'); ?></td>
                                <td>
                                    <?php if($res->refund_status == 1): ?>
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-success me-1"><?php echo e(__('lang.admin_refunded')); ?></span>
                                        </a>
                                    <?php else: ?>
                                        <?php if($res->order->payment_method=='cash'): ?>
                                            --
                                        <?php else: ?>
                                        <a href="javascript:;">
                                            <span class="badge rounded-pill badge-light-warning me-1"><?php echo e(__('lang.admin_not_yet')); ?></span>
                                        </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                     <?php if($res->order->payment_method=='cash'): ?>
                                    <a href="javascript:;">
                                        <span class="badge rounded-pill badge-light-info me-1"><?php echo e(__('lang.admin_cash_on_delivery')); ?></span>
                                    </a>
                                    <?php else: ?>
                                    <a href="javascript:;">
                                        <span class="badge rounded-pill badge-light-success me-1"><?php echo e(__('lang.admin_online')); ?></span>
                                    </a>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(isset($res->created_at) ? \Helpers::commonDateTimeFormate($res->created_at) : '--'); ?></td>
                                <td>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu">
                                            <?php if($res->status != 1): ?>
                                            <a class="dropdown-item" href="<?php echo e(url('admin/approved-order-request/'.$res->id)); ?>">
                                                <i data-feather="check" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_approved')); ?></span>
                                            </a>
                                            <?php endif; ?>
                                            <?php if($res->status != 2): ?>
                                            <a class="dropdown-item" href="<?php echo e(url('admin/declined-order-request/'.$res->id)); ?>">
                                                <i data-feather="x" class="me-50"></i>
                                                <span><?php echo e(__('lang.admin_declined')); ?></span>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="10" class="recordnotfound"><span><?php echo e(__('lang.admin_message_no_result_found')); ?></span></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div class="pagination" style="float: right;">
                        <?php echo e($data->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Striped rows end -->
</div><?php /**PATH /Applications/MAMP/htdocs/hayawater/resources/views/orders/cancelrequest/table.blade.php ENDPATH**/ ?>